/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import SevenZip.Archive.IInArchive;
import SevenZip.Archive.SevenZip.Handler;
import SevenZip.Archive.SevenZipEntry;
import SevenZip.IInStream;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.SevenZipInputStream;
import net.sourceforge.docfetcher.model.index.file.SevenZipUnpacker;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;

final class SevenZipTree
extends SolidArchiveTree<SevenZipEntry> {
    private IInArchive archive;

    public SevenZipTree(File file, IndexingConfig indexingConfig, Path path, SolidArchiveTree.FailReporter failReporter) throws IOException, ArchiveEncryptedException {
        super(file, indexingConfig, path, failReporter);
    }

    public SevenZipTree(File file, IndexingConfig indexingConfig, boolean bl, Path path, SolidArchiveTree.FailReporter failReporter) throws IOException, ArchiveEncryptedException {
        super(file, indexingConfig, bl, path, failReporter);
    }

    @Override
    protected SolidArchiveTree.ArchiveIterator<SevenZipEntry> getArchiveIterator(File file, String string) throws IOException, ArchiveEncryptedException {
        if (this.archive == null) {
            SevenZipInputStream sevenZipInputStream = new SevenZipInputStream(file);
            this.archive = new Handler();
            try {
                if (this.archive.Open((IInStream)sevenZipInputStream) != 0) {
                    this.archive.close();
                    throw new IOException();
                }
            }
            catch (IOException iOException) {
                this.archive.close();
                if ("k_7zAES not implemented".equals(iOException.getMessage())) {
                    throw new ArchiveEncryptedException(file, string);
                }
                throw iOException;
            }
        }
        return new SolidArchiveTree.ArchiveIterator<SevenZipEntry>(){
            private int index = 0;
            private int size;
            {
                this.size = SevenZipTree.this.archive.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public SevenZipEntry next() {
                if (this.index >= this.size) {
                    throw new NoSuchElementException();
                }
                return SevenZipTree.this.archive.getEntry(this.index++);
            }

            @Override
            public void finished() {
            }
        };
    }

    @Override
    protected SolidArchiveTree.ArchiveEntryReader<SevenZipEntry> getArchiveEntryReader() {
        return SevenZipEntryReader.instance;
    }

    @Override
    public void close() throws IOException {
        this.archive.close();
    }

    @Override
    protected Map<Integer, File> doUnpack(Map<Integer, TreeNode> map, SolidArchiveTree.TempFileFactory tempFileFactory) throws IOException {
        int[] nArray = new int[map.size()];
        int n = 0;
        for (Integer n2 : map.keySet()) {
            nArray[n++] = n2;
        }
        Unpacker unpacker = new Unpacker(map, tempFileFactory);
        return (Map)unpacker.unpack(nArray);
    }

    private static final class SevenZipEntryReader
    implements SolidArchiveTree.ArchiveEntryReader<SevenZipEntry> {
        private static final SevenZipEntryReader instance = new SevenZipEntryReader();

        private SevenZipEntryReader() {
        }

        @Override
        public String getInnerPath(SevenZipEntry sevenZipEntry) {
            String string = sevenZipEntry.getName();
            assert (string == null || !string.contains("\\") && !string.startsWith("/"));
            return string;
        }

        @Override
        public long getLastModified(SevenZipEntry sevenZipEntry) {
            return sevenZipEntry.getTime();
        }

        @Override
        public boolean isDirectory(SevenZipEntry sevenZipEntry) {
            return sevenZipEntry.isDirectory();
        }

        @Override
        public long getUnpackedSize(SevenZipEntry sevenZipEntry) {
            return sevenZipEntry.getSize();
        }

        @Override
        public boolean isEncrypted(SevenZipEntry sevenZipEntry) {
            return false;
        }
    }

    private class Unpacker
    extends SevenZipUnpacker<Map<Integer, File>> {
        private final Map<Integer, TreeNode> unpackMap;
        private final SolidArchiveTree.TempFileFactory tempFileFactory;
        private Map<Integer, File> indexFileMap;

        public Unpacker(Map<Integer, TreeNode> map, SolidArchiveTree.TempFileFactory tempFileFactory) {
            super(SevenZipTree.this.archive);
            this.indexFileMap = Maps.newHashMap();
            this.unpackMap = map;
            this.tempFileFactory = tempFileFactory;
        }

        @Override
        public File getOutputFile(int n) throws IOException {
            TreeNode treeNode = this.unpackMap.get(n);
            try {
                File file = this.tempFileFactory.createTempFile(treeNode);
                this.indexFileMap.put(n, file);
                return file;
            }
            catch (IndexingException indexingException) {
                SevenZipTree.this.failReporter.fail(IndexingError.ErrorType.ARCHIVE_ENTRY, treeNode, indexingException);
                throw indexingException.getIOException();
            }
        }

        @Override
        public Map<Integer, File> getUnpackResult() {
            return this.indexFileMap;
        }
    }
}

