/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.MutableInt;
import net.sourceforge.docfetcher.model.index.file.FileContext;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.LuceneDocWriter;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;

final class SolidArchiveContext
extends FileContext
implements SolidArchiveTree.FailReporter {
    private final boolean isTempArchive;
    final Map<FileDocument, FileFolder> addedDocs = new HashMap<FileDocument, FileFolder>();
    final Map<FileDocument, FileFolder> modifiedDocs = new HashMap<FileDocument, FileFolder>();
    final Map<FileFolder, FileFolder> nestedArchives = new HashMap<FileFolder, FileFolder>();

    protected SolidArchiveContext(IndexingConfig indexingConfig, TArchiveDetector tArchiveDetector, LuceneDocWriter luceneDocWriter, IndexingReporter indexingReporter, Path path, Cancelable cancelable, MutableInt mutableInt, boolean bl, File file) {
        super(indexingConfig, tArchiveDetector, luceneDocWriter, indexingReporter, path, cancelable, mutableInt, file);
        this.isTempArchive = bl;
    }

    protected SolidArchiveContext(FileContext fileContext, Path path, boolean bl, File file) {
        this(fileContext.getConfig(), fileContext.getZipDetector(), fileContext.getWriter(), fileContext.getReporter(), path, fileContext.getStopper(), fileContext.getFileCount(), bl, file);
    }

    public IndexingConfig getIndexingConfig() {
        return this.getConfig();
    }

    public List<TreeNode> getUnpackList() {
        int n = this.addedDocs.size() + this.modifiedDocs.size() + this.nestedArchives.size();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(n);
        if (n > 0) {
            arrayList.addAll(this.addedDocs.keySet());
            arrayList.addAll(this.modifiedDocs.keySet());
            arrayList.addAll(this.nestedArchives.keySet());
        }
        return arrayList;
    }

    public boolean isTempArchive() {
        return this.isTempArchive;
    }
}

