/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import java.io.File;
import java.io.IOException;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.RarTree;
import net.sourceforge.docfetcher.model.index.file.SevenZipTree;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveContext;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SolidArchiveFactory {
    Rar{

        @Override
        public SolidArchiveTree<?> createSolidArchiveTree(SolidArchiveContext solidArchiveContext, File file) throws IOException, ArchiveEncryptedException {
            return new RarTree(file, solidArchiveContext.getConfig(), solidArchiveContext.getOriginalPath(), solidArchiveContext);
        }
    }
    ,
    SevenZip{

        @Override
        public SolidArchiveTree<?> createSolidArchiveTree(SolidArchiveContext solidArchiveContext, File file) throws IOException, ArchiveEncryptedException {
            return new SevenZipTree(file, solidArchiveContext.getConfig(), solidArchiveContext.getOriginalPath(), solidArchiveContext);
        }
    };


    public abstract SolidArchiveTree<?> createSolidArchiveTree(SolidArchiveContext var1, File var2) throws IOException, ArchiveEncryptedException;
}

