/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.outlook;

import com.google.common.io.Closeables;
import com.pff.PSTMessage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;

abstract class AttachmentVisitor {
    private final IndexingConfig config;
    private final PSTMessage email;
    private final boolean deleteTempFiles;

    public AttachmentVisitor(IndexingConfig indexingConfig, PSTMessage pSTMessage, boolean bl) {
        Util.checkNotNull(indexingConfig, pSTMessage);
        this.config = indexingConfig;
        this.email = pSTMessage;
        this.deleteTempFiles = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        int n = this.email.getNumberOfAttachments();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = null;
            File file = null;
            try {
                object = this.email.getAttachment(i);
                string = object.getLongFilename();
                if (string.isEmpty()) {
                    string = object.getFilename();
                }
                file = this.config.createDerivedTempFile(string);
                InputStream inputStream = object.getFileInputStream();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                int n2 = 8176;
                byte[] byArray = new byte[n2];
                int n3 = inputStream.read(byArray);
                while (n3 > 0) {
                    fileOutputStream.write(byArray, 0, n3);
                    n3 = inputStream.read(byArray);
                }
                Closeables.closeQuietly((Closeable)fileOutputStream);
                Closeables.closeQuietly((Closeable)inputStream);
                this.handleAttachment(string, file);
                continue;
            }
            catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
                if (string == null) {
                    string = "???";
                }
                this.handleException(string, checkedOutOfMemoryError.getCause());
                continue;
            }
            catch (Exception exception) {
                if (string == null) {
                    string = "???";
                }
                if (exception instanceof IndexingException) {
                    object = ((IndexingException)exception).getIOException();
                }
                this.handleException(string, (Throwable)object);
                continue;
            }
            finally {
                if (this.deleteTempFiles && file != null) {
                    file.delete();
                }
            }
        }
        this.runFinally();
    }

    protected abstract void handleAttachment(String var1, File var2) throws ParseException, CheckedOutOfMemoryError;

    protected abstract void handleException(String var1, Throwable var2);

    protected void runFinally() {
    }
}

