/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.outlook;

import com.pff.PSTMessage;
import com.pff.PSTRecipient;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.IndexWriterAdapter;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.MutableInt;
import net.sourceforge.docfetcher.model.index.outlook.AttachmentVisitor;
import net.sourceforge.docfetcher.model.index.outlook.MailDocument;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

final class OutlookContext {
    private final IndexingConfig config;
    private final IndexWriterAdapter writer;
    private final IndexingReporter reporter;
    private final Cancelable cancelable;
    private final MutableInt fileCount = new MutableInt(0);

    public OutlookContext(IndexingConfig indexingConfig, IndexWriterAdapter indexWriterAdapter, IndexingReporter indexingReporter, Cancelable cancelable) {
        Util.checkNotNull(indexingConfig, indexWriterAdapter, indexingReporter, cancelable);
        this.config = indexingConfig;
        this.writer = indexWriterAdapter;
        this.reporter = indexingReporter;
        this.cancelable = cancelable;
    }

    public final boolean isStopped() {
        return this.cancelable.isCanceled();
    }

    public void index(MailDocument mailDocument, PSTMessage pSTMessage, boolean bl) throws IndexingException {
        this.fileCount.increment();
        this.reporter.info(new IndexingInfo(IndexingInfo.InfoType.EXTRACTING, mailDocument, this.fileCount.get()));
        try {
            mailDocument.setError(null);
            Document document = this.createLuceneDoc(mailDocument, pSTMessage);
            if (bl) {
                this.writer.add(document);
            } else {
                this.writer.update(mailDocument.getUniqueId(), document);
            }
        }
        catch (IOException iOException) {
            throw new IndexingException(iOException);
        }
        catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
            UtilModel.fail(this.reporter, IndexingError.ErrorType.OUT_OF_MEMORY, mailDocument, checkedOutOfMemoryError.getCause());
        }
    }

    public void deleteFromIndex(String string) throws IndexingException {
        try {
            this.writer.delete(string);
        }
        catch (IOException iOException) {
            throw new IndexingException(iOException);
        }
    }

    private Document createLuceneDoc(final MailDocument mailDocument, PSTMessage pSTMessage) {
        CharSequence charSequence;
        long l;
        final Document document = new Document();
        String string = pSTMessage.getSubject();
        String string2 = pSTMessage.getBody();
        String string3 = OutlookContext.getSender(pSTMessage);
        String string4 = Util.join(", ", OutlookContext.getRecipients(pSTMessage));
        try {
            l = string2.getBytes("utf-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            l = string2.getBytes().length;
        }
        document.add((IndexableField)Fields.UID.create(mailDocument.getUniqueId()));
        document.add((IndexableField)Fields.SUBJECT.create(string));
        document.add((IndexableField)Fields.TYPE.create("outlook"));
        document.add((IndexableField)Fields.SENDER.create(string3));
        document.add((IndexableField)Fields.RECIPIENTS.create(string4));
        document.add((IndexableField)Fields.SIZE.create(l));
        document.add((IndexableField)Fields.PARSER.create("EmailParser"));
        Date date = pSTMessage.getMessageDeliveryTime();
        if (date != null) {
            charSequence = String.valueOf(date.getTime());
            document.add((IndexableField)Fields.DATE.create((String)charSequence));
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string).append(" ");
        ((StringBuilder)charSequence).append(string3).append(" ");
        ((StringBuilder)charSequence).append(string4).append(" ");
        ((StringBuilder)charSequence).append(string2).append(" ");
        document.add((IndexableField)Fields.createContent(charSequence));
        new AttachmentVisitor(this.config, pSTMessage, true){
            private List<IndexingError> errors;

            @Override
            protected void handleAttachment(String string, File file) throws ParseException, CheckedOutOfMemoryError {
                Path path = mailDocument.getPath().createSubPath(string);
                ParseResult parseResult = ParseService.parse(OutlookContext.this.config, file, string, path, OutlookContext.this.reporter, OutlookContext.this.cancelable);
                document.add((IndexableField)Fields.createContent(parseResult.getContent()));
                StringBuilder stringBuilder = parseResult.getMetadata();
                stringBuilder.append(string);
                document.add((IndexableField)Fields.createContent(stringBuilder));
            }

            @Override
            protected void handleException(String string, Throwable throwable) {
                Path path = mailDocument.getPath().createSubPath(string);
                AttachNode attachNode = new AttachNode(path);
                if (this.errors == null) {
                    this.errors = new ArrayList<IndexingError>(5);
                }
                IndexingError indexingError = new IndexingError(IndexingError.ErrorType.ATTACHMENT, attachNode, throwable);
                this.errors.add(indexingError);
                OutlookContext.this.reporter.fail(indexingError);
            }

            @Override
            protected void runFinally() {
                mailDocument.setErrors(this.errors);
            }
        }.run();
        return document;
    }

    static String getSender(PSTMessage pSTMessage) {
        String string;
        String string2 = pSTMessage.getSenderName();
        if (string2.equals(string = pSTMessage.getSenderEmailAddress())) {
            return string;
        }
        return string2 + " <" + string + ">";
    }

    static List<String> getRecipients(PSTMessage pSTMessage) {
        try {
            int n = pSTMessage.getNumberOfRecipients();
            if (n == 0) {
                return new ArrayList<String>(0);
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                String string;
                PSTRecipient pSTRecipient = pSTMessage.getRecipient(i);
                String string2 = pSTRecipient.getDisplayName();
                if (string2.equals(string = pSTRecipient.getEmailAddress())) {
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(string2 + " <" + string + ">");
            }
            return arrayList;
        }
        catch (Exception exception) {
            return new ArrayList<String>(0);
        }
    }

    private static class AttachNode
    extends TreeNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Path path;

        public AttachNode(Path path) {
            super(path.getName());
            this.path = path;
        }

        @Override
        public Path getPath() {
            return this.path;
        }
    }
}

