/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.outlook;

import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTMessage;
import com.pff.PSTObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.docfetcher.model.HotColdFileCache;
import net.sourceforge.docfetcher.model.MailResource;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.outlook.OutlookMailResource;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.search.Query;

public final class OutlookMailFactory {
    private final HotColdFileCache unpackCache;

    public OutlookMailFactory(HotColdFileCache hotColdFileCache) {
        this.unpackCache = Util.checkNotNull(hotColdFileCache);
    }

    public MailResource createMail(IndexingConfig indexingConfig, Query query, boolean bl, Path path) throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
        Path.PathParts pathParts = path.splitAtLastSeparator();
        try {
            Path.PathParts pathParts2 = pathParts.getLeft().splitAtExistingFile();
            long l = Long.valueOf(pathParts.getRight());
            String string = pathParts2.getLeft().getCanonicalPath();
            PSTFile pSTFile = new PSTFile(string);
            PSTMessage pSTMessage = (PSTMessage)PSTObject.detectAndLoadPSTObject((PSTFile)pSTFile, (long)l);
            Path path2 = new Path(Util.joinPath(string, pathParts2.getRight(), pathParts.getRight()));
            return new OutlookMailResource(indexingConfig, query, bl, this.unpackCache, path2, pSTMessage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (PSTException pSTException) {
            throw new ParseException(pSTException);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }
}

