/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.outlook;

import com.pff.PSTMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.HotColdFileCache;
import net.sourceforge.docfetcher.model.MailResource;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.outlook.AttachmentVisitor;
import net.sourceforge.docfetcher.model.index.outlook.OutlookContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.search.HighlightService;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.search.Query;

public final class OutlookMailResource
extends MailResource {
    private final String subject;
    private final HighlightedString body;
    private final String sender;
    private final List<String> recipients;
    private final Date date;
    private final List<MailResource.Attachment> attachments;

    OutlookMailResource(IndexingConfig indexingConfig, Query query, boolean bl, final HotColdFileCache hotColdFileCache, final Path path, PSTMessage pSTMessage) throws ParseException, CheckedOutOfMemoryError {
        Util.checkNotNull(indexingConfig, hotColdFileCache, pSTMessage);
        this.subject = pSTMessage.getSubject();
        this.body = HighlightService.highlight(query, bl, pSTMessage.getBody());
        this.sender = OutlookContext.getSender(pSTMessage);
        this.recipients = OutlookContext.getRecipients(pSTMessage);
        this.date = pSTMessage.getMessageDeliveryTime();
        this.attachments = new ArrayList<MailResource.Attachment>(pSTMessage.getNumberOfAttachments());
        new AttachmentVisitor(indexingConfig, pSTMessage, false){

            @Override
            protected void handleAttachment(String string, File file) throws ParseException {
                Path path2 = path.createSubPath(string);
                FileResource fileResource = hotColdFileCache.putIfAbsent(path2, file);
                OutlookMailResource.this.attachments.add(new MailResource.Attachment(string, fileResource));
            }

            @Override
            protected void handleException(String string, Throwable throwable) {
            }
        }.run();
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public HighlightedString getBody() {
        return this.body;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    @Override
    public List<String> getRecipients() {
        return Collections.unmodifiableList(this.recipients);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public List<MailResource.Attachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }
}

