/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.zip.ZipFile;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.FileParser;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.UtilParser;

public final class EpubParser
extends FileParser {
    private static final Collection<String> extensions = Arrays.asList("epub");
    private static final Collection<String> types = Arrays.asList(MediaType.application("epub+zip"));

    @Override
    protected ParseResult parse(File file, ParseContext parseContext) throws ParseException {
        return this.parse(file, parseContext, false);
    }

    @Override
    protected String renderText(File file, String string) throws ParseException {
        ParseContext parseContext = new ParseContext(string);
        return this.parse(file, parseContext, true).getContent().toString();
    }

    protected ParseResult parse(File file, ParseContext parseContext, boolean bl) throws ParseException {
        Object object;
        ZipFile zipFile = null;
        try {
            Object object2;
            String string;
            Object object32;
            if (file instanceof TFile) {
                file = new File(file.getPath());
            }
            zipFile = new ZipFile(file);
            Source source = UtilParser.getSource(zipFile, "META-INF/container.xml");
            Element element = source.getNextElement(0, "rootfile");
            EpubParser.maybeThrow(element, "No rootfile element in META-INF/container.xml");
            String string2 = element.getAttributeValue("full-path");
            Source source2 = UtilParser.getSource(zipFile, string2);
            Element element2 = EpubParser.getFirstOpfElement((Segment)source2, "package");
            EpubParser.maybeThrow(element2, "No package element in OPF file");
            Element element3 = EpubParser.getFirstOpfElement((Segment)element2, "metadata");
            Element element4 = EpubParser.getFirstOpfElement((Segment)element2, "manifest");
            Element element5 = EpubParser.getFirstOpfElement((Segment)element2, "spine");
            EpubParser.maybeThrow(element3, "No metadata element in OPF file");
            EpubParser.maybeThrow(element4, "No manifest element in OPF file");
            EpubParser.maybeThrow(element5, "No spine element in OPF file");
            String string3 = UtilParser.extract(element3.getFirstElement("dc:title"));
            Element element6 = element3.getFirstElement("dc:creator");
            String string4 = null;
            if (element6 != null) {
                string4 = UtilParser.extract(element6);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Object object32 : element4.getChildElements()) {
                String string5 = object32.getAttributeValue("id");
                string = object32.getAttributeValue("href");
                hashMap.put(string5, string);
            }
            LinkedList linkedList = new LinkedList();
            for (String string5 : element5.getChildElements()) {
                string = (String)hashMap.get(string5.getAttributeValue("idref"));
                if (string == null) continue;
                try {
                    string = new URI(string).getPath();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                object2 = new File(string2).getParentFile();
                if (object2 != null) {
                    linkedList.add(new File((File)object2, string).getPath());
                    continue;
                }
                linkedList.add(string);
            }
            object32 = new StringBuilder();
            boolean bl2 = true;
            string = element3.getFirstElement("dc:description");
            if (string != null) {
                object2 = string.getContent().getTextExtractor().toString();
                Source source3 = new Source((CharSequence)object2);
                source3.setLogger(null);
                ((StringBuilder)object32).append(UtilParser.render((Segment)source3));
                bl2 = false;
            }
            int n = linkedList.size();
            int n2 = 1;
            object = linkedList.iterator();
            while (object.hasNext()) {
                Source source4;
                String string6 = (String)object.next();
                try {
                    source4 = UtilParser.getSource(zipFile, string6);
                }
                catch (ParseException parseException) {
                    continue;
                }
                Element element7 = source4.getNextElement(0, "body");
                if (element7 == null) continue;
                parseContext.getReporter().subInfo(n2, n);
                if (!bl2) {
                    ((StringBuilder)object32).append("\n\n");
                }
                if (bl) {
                    ((StringBuilder)object32).append(UtilParser.render((Segment)element7));
                } else {
                    ((StringBuilder)object32).append(UtilParser.extract(element7));
                }
                bl2 = false;
                ++n2;
            }
            object = new ParseResult((CharSequence)object32).setTitle(string3).addAuthor(string4);
        }
        catch (IOException iOException) {
            try {
                throw new ParseException(iOException);
            }
            catch (Throwable throwable) {
                UtilParser.closeZipFile(zipFile);
                throw throwable;
            }
        }
        UtilParser.closeZipFile(zipFile);
        return object;
    }

    private static <T> T maybeThrow(T t, String string) throws ParseException {
        if (t == null) {
            throw new ParseException(string);
        }
        return t;
    }

    private static Element getFirstOpfElement(Segment segment, String string) {
        Element element = segment.getFirstElement(string);
        if (element != null) {
            return element;
        }
        return segment.getFirstElement("opf:" + string);
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_epub.get();
    }
}

