/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import net.sourceforge.docfetcher.model.parse.VorbisComment;

final class FLACParser
extends StreamParser {
    private static final Collection<String> extensions = Arrays.asList("flac");
    private static final Collection<String> types = Arrays.asList("audio/flac");

    FLACParser() {
    }

    private static long[] readMetadataBlock(byte[] byArray) {
        long l = (byArray[0] & 0x80) >> 7;
        long l2 = byArray[0] & 0x7F;
        long l3 = 0L;
        for (int i = 1; i < 4; ++i) {
            l3 = (l3 << 8) + (long)(byArray[i] & 0xFF);
        }
        return new long[]{l, l2, l3};
    }

    private static String extract(InputStream inputStream, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != 1716281667) {
            return stringBuffer.toString();
        }
        long[] lArray = null;
        for (int i = 0; i < 100; ++i) {
            byte[] byArray = new byte[4];
            dataInputStream.readFully(byArray);
            lArray = FLACParser.readMetadataBlock(byArray);
            long l = lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            if (l2 == 4L) break;
            dataInputStream.skipBytes((int)l3);
            if (l != 0L) break;
        }
        VorbisComment vorbisComment = new VorbisComment();
        vorbisComment.parse(dataInputStream, stringBuffer, bl);
        return stringBuffer.toString();
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        String string = "";
        try {
            string = FLACParser.extract(inputStream, false);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        return new ParseResult(string);
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        String string2 = "";
        try {
            string2 = FLACParser.extract(inputStream, true);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        return string2;
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_flac.get();
    }
}

