/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import net.htmlparser.jericho.CharacterReference;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import net.sourceforge.docfetcher.model.parse.UtilParser;

public final class HtmlParser
extends StreamParser {
    private static final Collection<String> types = Arrays.asList(MediaType.text("html"), MediaType.application("xhtml+xml"), MediaType.application("vnd.wap.xhtml+xml"), MediaType.application("x-asp"));

    HtmlParser() {
    }

    @Override
    public ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        Source source;
        try {
            source = UtilParser.getSource(inputStream);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        source.setLogger(null);
        source.fullSequentialParse();
        Element element = source.getNextElement(0, "title");
        String string = element == null ? "" : CharacterReference.decodeCollapseWhiteSpace((CharSequence)element.getContent());
        String string2 = this.getMetaValue(source, "author");
        String string3 = this.getMetaValue(source, "description");
        String string4 = this.getMetaValue(source, "keywords");
        Element element2 = source.getNextElement(0, "body");
        String string5 = element2 != null ? element2.getContent().getTextExtractor().toString() : source.getRenderer().setIncludeHyperlinkURLs(false).toString();
        return new ParseResult(string5).setTitle(string).addAuthor(string2).addMiscMetadata(string3).addMiscMetadata(string4);
    }

    private String getMetaValue(Source source, String string) {
        int n = 0;
        while (n < source.length()) {
            StartTag startTag = source.getNextStartTag(n, "name", string, false);
            if (startTag == null) {
                return null;
            }
            if (startTag.getName() == "meta") {
                return startTag.getAttributeValue("content");
            }
            n = startTag.getEnd();
        }
        return null;
    }

    @Override
    protected String renderText(InputStream inputStream, String string) throws ParseException {
        try {
            Source source = UtilParser.getSource(inputStream);
            source.setLogger(null);
            return source.getRenderer().setIncludeHyperlinkURLs(false).toString();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_html.get();
    }
}

