/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.parse.MSOfficeParser;
import net.sourceforge.docfetcher.model.parse.ParseException;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

final class MSExcelParser
extends MSOfficeParser {
    public MSExcelParser() {
        super(Msg.filetype_xls.get(), "xls", "xlt");
    }

    @Override
    protected String extractText(File file) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected String renderText(File file, String string) throws ParseException {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        ExcelExtractor excelExtractor = null;
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem((InputStream)fileInputStream);
        excelExtractor = new ExcelExtractor(pOIFSFileSystem);
        excelExtractor.setFormulasNotResults(ProgramConf.Bool.IndexExcelFormulas.get());
        excelExtractor.setIncludeCellComments(true);
        String string2 = excelExtractor.getText();
        Closeables.closeQuietly((Closeable)excelExtractor);
        Closeables.closeQuietly((Closeable)fileInputStream);
        return string2;
        {
            catch (OldExcelFormatException oldExcelFormatException) {
                Closeables.closeQuietly((Closeable)fileInputStream);
                String string3 = this.extractWithJexcelAPI(file);
                Closeables.closeQuietly((Closeable)excelExtractor);
                Closeables.closeQuietly((Closeable)fileInputStream);
                return string3;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                Closeables.closeQuietly(excelExtractor);
                                throw throwable;
                            }
                            catch (IOException iOException) {
                                throw new ParseException(iOException);
                            }
                            catch (RuntimeException runtimeException) {
                                throw new ParseException(runtimeException);
                            }
                        }
                        catch (Throwable throwable2) {
                            Closeables.closeQuietly(fileInputStream);
                            throw throwable2;
                        }
                    }
                }
            }
        }
    }

    private String extractWithJexcelAPI(File file) throws ParseException {
        WorkbookSettings workbookSettings = new WorkbookSettings();
        workbookSettings.setSuppressWarnings(true);
        try (Workbook workbook = null;){
            workbook = Workbook.getWorkbook((File)file, (WorkbookSettings)workbookSettings);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheet(i);
                stringBuilder.append(sheet.getName()).append("\n\n");
                for (int j = 0; j < sheet.getRows(); ++j) {
                    Cell[] cellArray = sheet.getRow(j);
                    for (int k = 0; k < cellArray.length; ++k) {
                        stringBuilder.append(cellArray[k].getContents()).append(" ");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("\n\n\n");
            }
            String string = stringBuilder.toString();
            return string;
        }
    }
}

