/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.parse.FileParser;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackageProperties;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;

abstract class MSOffice2007Parser
extends FileParser {
    private final Collection<String> types = MediaType.Col.application("zip");
    private final String typeLabel;
    private final Collection<String> extensions;

    private MSOffice2007Parser(String string, String ... stringArray) {
        this.typeLabel = string;
        this.extensions = Arrays.asList(stringArray);
    }

    @Override
    protected ParseResult parse(File file, ParseContext parseContext) throws ParseException {
        OPCPackage oPCPackage = null;
        try {
            oPCPackage = OPCPackage.open((String)file.getPath(), (PackageAccess)PackageAccess.READ);
            String string = MSOffice2007Parser.extractText(oPCPackage);
            PackageProperties packageProperties = oPCPackage.getPackageProperties();
            Object object = null;
            String string2 = (String)packageProperties.getCreatorProperty().getValue();
            String string3 = (String)packageProperties.getLastModifiedByProperty().getValue();
            if (string2 == null) {
                if (string3 != null) {
                    object = string3;
                }
            } else {
                object = string3 == null ? string2 : (string2.equals(string3) ? string2 : string2 + ", " + string3);
            }
            String string4 = (String)packageProperties.getDescriptionProperty().getValue();
            String string5 = (String)packageProperties.getKeywordsProperty().getValue();
            String string6 = (String)packageProperties.getSubjectProperty().getValue();
            String string7 = (String)packageProperties.getTitleProperty().getValue();
            ParseResult parseResult = new ParseResult(string).setTitle(string7).addAuthor((String)object).addMiscMetadata(string4).addMiscMetadata(string5).addMiscMetadata(string6);
            return parseResult;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (noClassDefFoundError.getMessage().contains("Could not initialize class")) {
                String string = "Outdated Java version. Please upgrade to Java 1.6.0 Update 18 or newer.";
                throw new ParseException(string, noClassDefFoundError);
            }
            throw noClassDefFoundError;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (noSuchMethodError.getMessage().contains("XMLEventFactory.newFactory")) {
                String string = "Outdated Java version. Please upgrade to Java 1.6.0 Update 18 or newer.";
                throw new ParseException(string, noSuchMethodError);
            }
            throw noSuchMethodError;
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        finally {
            try {
                Closeables.closeQuietly((Closeable)oPCPackage);
            }
            catch (OpenXML4JRuntimeException openXML4JRuntimeException) {}
        }
    }

    @Override
    protected final String renderText(File file, String string) throws ParseException {
        String string2;
        OPCPackage oPCPackage = null;
        try {
            oPCPackage = OPCPackage.open((String)file.getPath(), (PackageAccess)PackageAccess.READ);
            string2 = MSOffice2007Parser.extractText(oPCPackage);
        }
        catch (Exception exception) {
            try {
                throw new ParseException(exception);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(oPCPackage);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)oPCPackage);
        return string2;
    }

    private static String extractText(OPCPackage oPCPackage) throws Exception {
        Object object;
        POIXMLTextExtractor pOIXMLTextExtractor = ExtractorFactory.createExtractor((OPCPackage)oPCPackage);
        if (pOIXMLTextExtractor instanceof XSSFExcelExtractor) {
            object = (XSSFExcelExtractor)pOIXMLTextExtractor;
            boolean bl = ProgramConf.Bool.IndexExcelFormulas.get();
            object.setFormulasNotResults(bl);
            object.setIncludeCellComments(true);
        }
        object = pOIXMLTextExtractor.getText();
        return object;
    }

    @Override
    protected final Collection<String> getExtensions() {
        return this.extensions;
    }

    @Override
    protected final Collection<String> getTypes() {
        return this.types;
    }

    @Override
    public final String getTypeLabel() {
        return this.typeLabel;
    }

    static {
        ZipSecureFile.setMinInflateRatio((double)0.0);
        ZipSecureFile.setMaxEntrySize((long)0xFFFFFFFFL);
        ZipSecureFile.setMaxTextSize((long)0xFFFFFFFFL);
    }

    public static final class MSPowerPoint2007Parser
    extends MSOffice2007Parser {
        public MSPowerPoint2007Parser() {
            super(Msg.filetype_pptx.get(), "pptx", "pptm", "ppsx", "ppsm", "potx", "potm");
        }
    }

    public static final class MSExcel2007Parser
    extends MSOffice2007Parser {
        public MSExcel2007Parser() {
            super(Msg.filetype_xlsx.get(), "xlsx", "xlsm", "xltx", "xltm");
        }
    }

    public static final class MSWord2007Parser
    extends MSOffice2007Parser {
        public MSWord2007Parser() {
            super(Msg.filetype_docx.get(), "docx", "docm", "dotx", "dotm");
        }
    }
}

