/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.File;
import junit.framework.Assert;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.parse.ParseService;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.junit.Test;

public final class MSOffice2007ParserTest {
    @Test
    public void testReadOnlySucceeds() throws Exception {
        File file = TestFiles.read_write_xls.get();
        OPCPackage oPCPackage = OPCPackage.open((String)file.getPath(), (PackageAccess)PackageAccess.READ);
        ExtractorFactory.createExtractor((OPCPackage)oPCPackage).getText();
    }

    @Test
    public void testReadWriteSucceeds() throws Exception {
        File file = TestFiles.read_write_xls.get();
        OPCPackage oPCPackage = OPCPackage.open((String)file.getPath(), (PackageAccess)PackageAccess.READ_WRITE);
        ExtractorFactory.createExtractor((OPCPackage)oPCPackage).getText();
    }

    @Test
    public void testParse() throws Exception {
        File file = TestFiles.read_write_xls.get();
        long l = file.length();
        long l2 = file.lastModified();
        ParseService.parse(new IndexingConfig(), file, file.getName(), new Path(file), IndexingReporter.nullReporter, Cancelable.nullCancelable);
        Assert.assertEquals((long)l, (long)file.length());
        Assert.assertEquals((long)l2, (long)file.lastModified());
    }
}

