/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.FileParser;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.util.Util;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import org.apache.poi.hslf.exceptions.OldPowerPointFormatException;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.extractor.Word6Extractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;

abstract class MSOfficeParser
extends FileParser {
    private static final Collection<String> types = MediaType.Col.application("msword");
    private final String typeLabel;
    private final Collection<String> extensions;

    MSOfficeParser(String string, String ... stringArray) {
        this.typeLabel = string;
        this.extensions = Arrays.asList(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final ParseResult parse(File file, ParseContext parseContext) throws ParseException {
        String string = this.renderText(file, parseContext.getFilename());
        ParseResult parseResult = new ParseResult(string);
        POIFSReader pOIFSReader = new POIFSReader();
        MyReaderListener myReaderListener = new MyReaderListener();
        pOIFSReader.registerListener((POIFSReaderListener)myReaderListener, "\u0005SummaryInformation");
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            try {
                pOIFSReader.read((InputStream)fileInputStream);
            }
            catch (RuntimeException runtimeException) {
                throw new ParseException(runtimeException);
            }
            parseResult.setTitle(myReaderListener.title).addAuthor(myReaderListener.author).addMiscMetadata(myReaderListener.subject).addMiscMetadata(myReaderListener.keywords).addMiscMetadata(myReaderListener.comments);
        }
        catch (IOException iOException) {
            try {
                Util.printErr(iOException);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fileInputStream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)fileInputStream);
        }
        Closeables.closeQuietly((Closeable)fileInputStream);
        return parseResult;
    }

    @Override
    protected String renderText(File file, String string) throws ParseException {
        try {
            return this.extractText(file);
        }
        catch (AssertionError assertionError) {
            throw new ParseException((Throwable)((Object)assertionError));
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException);
        }
    }

    protected abstract String extractText(File var1) throws IOException, ParseException;

    @Override
    protected final Collection<String> getExtensions() {
        return this.extensions;
    }

    @Override
    protected final Collection<String> getTypes() {
        return types;
    }

    @Override
    public final String getTypeLabel() {
        return this.typeLabel;
    }

    private static final class MyReaderListener
    implements POIFSReaderListener {
        public String author;
        public String title;
        public String subject;
        public String keywords;
        public String comments;

        private MyReaderListener() {
        }

        public void processPOIFSReaderEvent(POIFSReaderEvent pOIFSReaderEvent) {
            try {
                SummaryInformation summaryInformation = (SummaryInformation)PropertySetFactory.create((InputStream)pOIFSReaderEvent.getStream());
                String string = summaryInformation.getAuthor();
                String string2 = summaryInformation.getLastAuthor();
                Object object = string == null || string.equals(string2) ? string : string + ", " + string2;
                this.author = object;
                this.title = summaryInformation.getTitle();
                this.subject = summaryInformation.getSubject();
                this.keywords = summaryInformation.getKeywords();
                this.comments = summaryInformation.getComments();
            }
            catch (Exception exception) {
                Util.printErr(exception);
            }
        }
    }

    public static final class MSVisioParser
    extends MSOfficeParser {
        public MSVisioParser() {
            super(Msg.filetype_vsd.get(), "vsd", "vss", "vst", "vsw");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String extractText(File file) throws IOException {
            String string;
            VisioTextExtractor visioTextExtractor = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                visioTextExtractor = new VisioTextExtractor((InputStream)fileInputStream);
                string = visioTextExtractor.getText();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(visioTextExtractor);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)visioTextExtractor);
            return string;
        }
    }

    public static final class MSPowerPointParser
    extends MSOfficeParser {
        public MSPowerPointParser() {
            super(Msg.filetype_ppt.get(), "ppt", "pps", "pot");
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected String extractText(File file) throws IOException, ParseException {
            String string;
            PowerPointExtractor powerPointExtractor = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                powerPointExtractor = new PowerPointExtractor((InputStream)fileInputStream);
                powerPointExtractor.setNotesByDefault(true);
                powerPointExtractor.setCommentsByDefault(true);
                powerPointExtractor.setMasterByDefault(true);
                string = powerPointExtractor.getText(true, true, true, true);
            }
            catch (OldPowerPointFormatException oldPowerPointFormatException) {
                try {
                    throw new ParseException(oldPowerPointFormatException);
                    catch (EncryptedPowerPointFileException encryptedPowerPointFileException) {
                        throw new ParseException(Msg.doc_pw_protected.get());
                    }
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(powerPointExtractor);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)powerPointExtractor);
            return string;
        }
    }

    public static final class MSWordParser
    extends MSOfficeParser {
        public MSWordParser() {
            super(Msg.filetype_doc.get(), "doc", "dot");
        }

        /*
         * Loose catch block
         */
        @Override
        protected String extractText(File file) throws IOException, ParseException {
            String string;
            WordExtractor wordExtractor = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                wordExtractor = new WordExtractor((InputStream)fileInputStream);
                string = wordExtractor.getText();
            }
            catch (OldWordFileFormatException oldWordFileFormatException) {
                FileInputStream fileInputStream = new FileInputStream(file);
                wordExtractor = new Word6Extractor((InputStream)fileInputStream);
                String string2 = wordExtractor.getText();
                Closeables.closeQuietly((Closeable)wordExtractor);
                return string2;
            }
            catch (EncryptedDocumentException encryptedDocumentException) {
                throw new ParseException(Msg.doc_pw_protected.get());
                {
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(wordExtractor);
                        throw throwable;
                    }
                }
            }
            Closeables.closeQuietly((Closeable)wordExtractor);
            return string;
        }
    }
}

