/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.FileParser;
import net.sourceforge.docfetcher.model.parse.OpenOfficeParser;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import org.junit.Test;

public class OpenOfficeParserTest {
    @Test
    public void testPasswordProtected() throws Exception {
        block2: {
            OpenOfficeParser.OpenOfficeWriterParser openOfficeWriterParser = new OpenOfficeParser.OpenOfficeWriterParser();
            File file = TestFiles.encrypted_odt.get();
            try {
                ((FileParser)openOfficeWriterParser).parse(file, new ParseContext(file.getName()));
            }
            catch (ParseException parseException) {
                if (!parseException.getMessage().equals(Msg.doc_pw_protected.get())) break block2;
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Test
    public void testNotPasswordProtected() throws Exception {
        File[] fileArray;
        OpenOfficeParser.OpenOfficeWriterParser openOfficeWriterParser = new OpenOfficeParser.OpenOfficeWriterParser();
        for (File file : fileArray = new File[]{TestFiles.lorem_ipsum_odt.get(), new TFile(TestFiles.lorem_ipsum_odt.get())}) {
            ((FileParser)openOfficeWriterParser).parse(file, new ParseContext(file.getName()));
        }
    }

    @Test
    public void testMetaXmlMissing() throws Exception {
        OpenOfficeParser.OpenOfficeWriterParser openOfficeWriterParser = new OpenOfficeParser.OpenOfficeWriterParser();
        File file = TestFiles.missing_meta_xml_entry.get();
        ((FileParser)openOfficeWriterParser).parse(file, new ParseContext(file.getName()));
    }
}

