/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.parse.AbiWordParser;
import net.sourceforge.docfetcher.model.parse.HtmlParser;
import net.sourceforge.docfetcher.model.parse.MSExcelParser;
import net.sourceforge.docfetcher.model.parse.MSOffice2007Parser;
import net.sourceforge.docfetcher.model.parse.MSOfficeParser;
import net.sourceforge.docfetcher.model.parse.OpenOfficeParser;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.model.parse.PdfParser;
import net.sourceforge.docfetcher.model.parse.RtfParser;
import net.sourceforge.docfetcher.model.parse.SvgParser;
import net.sourceforge.docfetcher.model.parse.TextParser;
import net.sourceforge.docfetcher.util.collect.ListMap;
import org.junit.Assert;
import org.junit.Test;

public final class ParseServiceTest {
    @Test
    public void testMimeTypeDetection() throws Exception {
        ListMap<File, AbiWordParser> listMap = ListMap.create().add(TestFiles.lorem_ipsum_abw.get(), new AbiWordParser()).add(TestFiles.lorem_ipsum_abw_gz.get(), new AbiWordParser()).add(TestFiles.lorem_ipsum_docx.get(), (AbiWordParser)((Object)new MSOffice2007Parser.MSWord2007Parser())).add(TestFiles.lorem_ipsum_html.get(), (AbiWordParser)((Object)new HtmlParser())).add(TestFiles.lorem_ipsum_odt.get(), (AbiWordParser)((Object)new OpenOfficeParser.OpenOfficeWriterParser())).add(TestFiles.lorem_ipsum_pdf.get(), (AbiWordParser)((Object)new PdfParser())).add(TestFiles.lorem_ipsum_rtf.get(), (AbiWordParser)((Object)new RtfParser())).add(TestFiles.lorem_ipsum_svg.get(), (AbiWordParser)((Object)new SvgParser())).add(TestFiles.lorem_ipsum_txt.get(), (AbiWordParser)((Object)new TextParser())).add(TestFiles.lorem_ipsum_doc_97.get(), (AbiWordParser)((Object)new MSOfficeParser.MSWordParser())).add(TestFiles.lorem_ipsum_xls_5_0.get(), (AbiWordParser)((Object)new MSExcelParser())).add(TestFiles.lorem_ipsum_xls_95.get(), (AbiWordParser)((Object)new MSExcelParser())).add(TestFiles.lorem_ipsum_xls_97.get(), (AbiWordParser)((Object)new MSExcelParser())).add(TestFiles.lorem_ipsum_ppt_97.get(), (AbiWordParser)((Object)new MSOfficeParser.MSPowerPointParser()));
        for (ListMap.Entry<File, AbiWordParser> entry : listMap) {
            List<String> list;
            Collection<String> collection = ((Parser)entry.getValue()).getTypes();
            Assert.assertTrue((!Collections.disjoint(collection, list = ParseService.getPossibleMimeTypes(entry.getKey())) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMimeTypeOverlap() throws Exception {
        IndexingConfig indexingConfig = new IndexingConfig();
        File file = TestFiles.lorem_ipsum_odt.get();
        List<Parser> list = ParseService.getSortedMatchingParsers(indexingConfig, file, file.getName());
        Assert.assertTrue((boolean)this.equalClasses(list, OpenOfficeParser.OpenOfficeWriterParser.class, MSOffice2007Parser.MSExcel2007Parser.class, MSOffice2007Parser.MSPowerPoint2007Parser.class, MSOffice2007Parser.MSWord2007Parser.class, OpenOfficeParser.OpenOfficeCalcParser.class, OpenOfficeParser.OpenOfficeDrawParser.class, OpenOfficeParser.OpenOfficeImpressParser.class));
        File file2 = TestFiles.lorem_ipsum_docx.get();
        List<Parser> list2 = ParseService.getSortedMatchingParsers(indexingConfig, file2, file2.getName());
        Assert.assertTrue((boolean)this.equalClasses(list2, MSOffice2007Parser.MSWord2007Parser.class, MSOffice2007Parser.MSExcel2007Parser.class, MSOffice2007Parser.MSPowerPoint2007Parser.class, OpenOfficeParser.OpenOfficeCalcParser.class, OpenOfficeParser.OpenOfficeDrawParser.class, OpenOfficeParser.OpenOfficeImpressParser.class, OpenOfficeParser.OpenOfficeWriterParser.class));
    }

    private boolean equalClasses(Collection<?> collection, Class<?> ... classArray) {
        if (collection.size() != classArray.length) {
            return false;
        }
        int n = 0;
        for (Object obj : collection) {
            if (!obj.getClass().equals(classArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

