/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.PDFTextAndAnnotationStripper;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

public final class PdfParser
extends StreamParser {
    private static final Collection<String> extensions = Collections.singleton("pdf");
    private static final Collection<String> types = MediaType.Col.application("pdf");

    PdfParser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, final ParseContext parseContext) throws ParseException {
        PDDocument pDDocument = null;
        try {
            int n;
            try {
                pDDocument = PDDocument.load((InputStream)inputStream);
            }
            catch (InvalidPasswordException invalidPasswordException) {
                throw new ParseException(Msg.doc_pw_protected.get());
            }
            catch (RuntimeException runtimeException) {
                throw new ParseException(runtimeException);
            }
            try {
                n = pDDocument.getNumberOfPages();
            }
            catch (RuntimeException runtimeException) {
                throw new ParseException(runtimeException);
            }
            StringWriter stringWriter = new StringWriter();
            final StringBuilder stringBuilder = new StringBuilder();
            PDFTextAndAnnotationStripper pDFTextAndAnnotationStripper = new PDFTextAndAnnotationStripper(){

                protected void startPage(PDPage pDPage) throws IOException {
                    parseContext.getReporter().subInfo(this.getCurrentPageNo(), n);
                }

                @Override
                protected boolean isCanceled() {
                    return parseContext.getCancelable().isCanceled();
                }

                @Override
                protected void writeAnnotations(PDPage pDPage) {
                    try {
                        for (PDAnnotation pDAnnotation : pDPage.getAnnotations()) {
                            if (!(pDAnnotation instanceof PDAnnotationMarkup)) continue;
                            PDAnnotationMarkup pDAnnotationMarkup = (PDAnnotationMarkup)pDAnnotation;
                            String string = pDAnnotationMarkup.getTitlePopup();
                            String string2 = pDAnnotationMarkup.getSubject();
                            String string3 = pDAnnotationMarkup.getContents();
                            if (string != null) {
                                stringBuilder.append(string + " ");
                            }
                            if (string2 != null) {
                                stringBuilder.append(string2 + " ");
                            }
                            if (string3 == null) continue;
                            stringBuilder.append(string3 + " ");
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                }
            };
            try {
                pDFTextAndAnnotationStripper.writeText(pDDocument, stringWriter);
            }
            catch (RuntimeException runtimeException) {
                throw new ParseException(runtimeException);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                throw new ParseException(exceptionInInitializerError);
            }
            stringWriter.write(" ");
            stringWriter.write(stringBuilder.toString());
            ParseResult parseResult = new ParseResult(stringWriter.getBuffer());
            PdfParser.extractMetadata(pDDocument, parseResult);
            ParseResult parseResult2 = parseResult;
            return parseResult2;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        finally {
            Closeables.closeQuietly((Closeable)pDDocument);
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        return extensions;
    }

    @Override
    protected Collection<String> getTypes() {
        return types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_pdf.get();
    }

    private static void extractMetadata(PDDocument pDDocument, ParseResult parseResult) {
        block10: {
            try {
                PDDocumentCatalog pDDocumentCatalog;
                PDMetadata pDMetadata;
                PDDocumentInformation pDDocumentInformation = pDDocument.getDocumentInformation();
                if (pDDocumentInformation != null) {
                    parseResult.setTitle(pDDocumentInformation.getTitle());
                    parseResult.addAuthor(pDDocumentInformation.getAuthor());
                    parseResult.addMiscMetadata(pDDocumentInformation.getSubject());
                    parseResult.addMiscMetadata(pDDocumentInformation.getKeywords());
                }
                if ((pDMetadata = (pDDocumentCatalog = pDDocument.getDocumentCatalog()).getMetadata()) == null) break block10;
                try {
                    Object object;
                    DomXmpParser domXmpParser = new DomXmpParser();
                    XMPMetadata xMPMetadata = domXmpParser.parse((InputStream)pDMetadata.createInputStream());
                    DublinCoreSchema dublinCoreSchema = xMPMetadata.getDublinCoreSchema();
                    if (dublinCoreSchema != null) {
                        parseResult.addMiscMetadata(dublinCoreSchema.getDescription());
                        object = dublinCoreSchema.getSubjects();
                        if (object != null) {
                            for (String string : dublinCoreSchema.getSubjects()) {
                                parseResult.addMiscMetadata(string);
                            }
                        }
                    }
                    if ((object = xMPMetadata.getAdobePDFSchema()) != null) {
                        parseResult.addMiscMetadata(object.getKeywords());
                    }
                }
                catch (XmpParsingException xmpParsingException) {
                }
                catch (IOException iOException) {}
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }
}

