/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.parse.MediaType;
import net.sourceforge.docfetcher.model.parse.ParseContext;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.StreamParser;
import net.sourceforge.docfetcher.util.CharsetDetectorHelper;

public final class TextParser
extends StreamParser {
    private final Collection<String> types = MediaType.Col.text("plain");

    TextParser() {
    }

    @Override
    protected ParseResult parse(InputStream inputStream, ParseContext parseContext) throws ParseException {
        try {
            CharsetDetectorHelper.charsetOverride = ProgramConf.Str.TextEncodingOverride.get().trim();
            String string = CharsetDetectorHelper.toString(inputStream);
            return new ParseResult(string);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
    }

    @Override
    protected Collection<String> getExtensions() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Collection<String> getTypes() {
        return this.types;
    }

    @Override
    public String getTypeLabel() {
        return Msg.filetype_txt.get();
    }
}

