/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.search;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.index.IndexWriterAdapter;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.model.search.Range;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TokenGroup;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldTermStack;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public final class HighlightService {
    private HighlightService() {
    }

    public static HighlightedString highlight(Query query, boolean bl, String string) throws CheckedOutOfMemoryError {
        string = HighlightService.trimDocument(string);
        List<Range> list = bl ? HighlightService.highlightPhrases(query, string) : HighlightService.highlight(query, string);
        return new HighlightedString(string, list);
    }

    private static String trimDocument(String string) {
        string = Util.trimRight(string);
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                n = i + 1;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return string.substring(n);
        }
        return "";
    }

    private static List<Range> highlightPhrases(Query query, String string) throws CheckedOutOfMemoryError {
        FastVectorHighlighter fastVectorHighlighter = new FastVectorHighlighter(true, true, null, null);
        FieldQuery fieldQuery = fastVectorHighlighter.getFieldQuery(query);
        RAMDirectory rAMDirectory = new RAMDirectory();
        try {
            IndexWriterAdapter indexWriterAdapter = new IndexWriterAdapter((Directory)rAMDirectory);
            Document document = new Document();
            document.add((IndexableField)Fields.createContent(string, true));
            indexWriterAdapter.add(document);
            Closeables.closeQuietly((Closeable)indexWriterAdapter);
            DirectoryReader directoryReader = DirectoryReader.open((Directory)rAMDirectory);
            FieldTermStack fieldTermStack = new FieldTermStack((IndexReader)directoryReader, 0, Fields.CONTENT.key(), fieldQuery);
            FieldPhraseList fieldPhraseList = new FieldPhraseList(fieldTermStack, fieldQuery);
            Field field = fieldPhraseList.getClass().getDeclaredField("phraseList");
            field.setAccessible(true);
            LinkedList linkedList = (LinkedList)field.get(fieldPhraseList);
            ArrayList<Range> arrayList = new ArrayList<Range>(linkedList.size());
            for (FieldPhraseList.WeightedPhraseInfo weightedPhraseInfo : linkedList) {
                int n = weightedPhraseInfo.getStartOffset();
                int n2 = weightedPhraseInfo.getEndOffset();
                arrayList.add(new Range(n, n2 - n));
            }
            return arrayList;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
        catch (Exception exception) {
            return new ArrayList<Range>(0);
        }
    }

    private static List<Range> highlight(Query query, String string) throws CheckedOutOfMemoryError {
        final ArrayList<Range> arrayList = new ArrayList<Range>();
        Formatter formatter = new Formatter(){

            public String highlightTerm(String string, TokenGroup tokenGroup) {
                for (int i = 0; i < tokenGroup.getNumTokens(); ++i) {
                    Token token = tokenGroup.getToken(i);
                    if (tokenGroup.getScore(i) == 0.0f) continue;
                    int n = token.startOffset();
                    int n2 = token.endOffset();
                    arrayList.add(new Range(n, n2 - n));
                }
                return null;
            }
        };
        String string2 = Fields.CONTENT.key();
        Highlighter highlighter = new Highlighter(formatter, (Scorer)new QueryScorer(query, string2));
        highlighter.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
        highlighter.setTextFragmenter((Fragmenter)new NullFragmenter());
        try {
            highlighter.getBestFragment(IndexRegistry.getAnalyzer(), string2, string);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
        catch (Exception exception) {
            Util.printErr(exception);
        }
        return arrayList;
    }
}

