/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.search;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import net.sourceforge.docfetcher.model.FieldTypes;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.index.IndexWriterAdapter;
import org.ansj.library.DicLibrary;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FieldTermStack;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.junit.Assert;
import org.junit.Test;

public final class HighlightServiceTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPhraseHighlighter() throws Exception {
        RAMDirectory rAMDirectory = new RAMDirectory();
        Analyzer analyzer = IndexRegistry.getAnalyzer();
        IndexWriterAdapter indexWriterAdapter = new IndexWriterAdapter((Directory)rAMDirectory);
        Document document = new Document();
        document.add((IndexableField)new org.apache.lucene.document.Field("content", "some text", FieldTypes.TYPE_TEXT_WITH_POSITIONS_OFFSETS_NOT_STORED));
        indexWriterAdapter.add(document);
        Closeables.closeQuietly((Closeable)indexWriterAdapter);
        QueryParser queryParser = new QueryParser("content", analyzer);
        Query query = queryParser.parse("\"text\"");
        FastVectorHighlighter fastVectorHighlighter = new FastVectorHighlighter(true, true, null, null);
        FieldQuery fieldQuery = fastVectorHighlighter.getFieldQuery(query);
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)rAMDirectory));
            TopDocs topDocs = indexSearcher.search(query, 10);
            Assert.assertEquals((long)1L, (long)topDocs.scoreDocs.length);
            int n = topDocs.scoreDocs[0].doc;
            FieldTermStack fieldTermStack = new FieldTermStack(indexSearcher.getIndexReader(), n, "content", fieldQuery);
            FieldPhraseList fieldPhraseList = new FieldPhraseList(fieldTermStack, fieldQuery);
            Field field = fieldPhraseList.getClass().getDeclaredField("phraseList");
            field.setAccessible(true);
            LinkedList linkedList = (LinkedList)field.get(fieldPhraseList);
            Assert.assertEquals((long)5L, (long)((FieldPhraseList.WeightedPhraseInfo)linkedList.get(0)).getStartOffset());
            Assert.assertEquals((long)9L, (long)((FieldPhraseList.WeightedPhraseInfo)linkedList.get(0)).getEndOffset());
        }
        finally {
            Closeables.closeQuietly((Closeable)indexSearcher.getIndexReader());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChinesePhraseHighlighter() throws Exception {
        RAMDirectory rAMDirectory = new RAMDirectory();
        Analyzer analyzer = IndexRegistry.getAnalyzer();
        IndexWriterAdapter indexWriterAdapter = new IndexWriterAdapter((Directory)rAMDirectory);
        Document document = new Document();
        DicLibrary.insert((String)"dic", (String)"\u4ea4\u901a\u5b89\u5168", (String)"ansj", (int)2000);
        DicLibrary.insert((String)"dic", (String)"\u4ea4\u901a", (String)"ansj", (int)2000);
        DicLibrary.insert((String)"dic", (String)"\u5b89\u5168", (String)"ansj", (int)2000);
        String string = "\u6ce8\u610f\u4ea4\u901a\u5b89\u5168\u51fa\u884c\uff1a\u4e0d\u5f3a\u884c\u4e0a\u4e0b\u8f66\uff0c\u505a\u5230\u5148\u4e0b\u540e\u4e0a\uff0c\u5019\u8f66\u8981\u6392\u961f\uff0c\u6309\u79e9\u5e8f\u4e0a\u8f66\uff1b\u4e0b\u8f66\u540e\u8981\u7b49\u8f66\u8f86\u5f00\u8d70\u540e\u518d\u884c\u8d70\uff0c\u5982\u8981\u7a7f\u8d8a\u9a6c\u8def\uff0c\u4e00\u5b9a\u8981\u786e\u4fdd\u5b89\u5168\u7684\u60c5\u51b5\u4e0b\u7a7f\u884c\uff1b\u4ea4\u901a\u4fe1\u53f7\u706f\u7684\u6b63\u786e\u4f7f\u7528\uff0c\u4ec0\u4e48\u4e8b\u4ea4\u901a\u5b89\u5168\u51fa\u884c\u4ea4\u901a\u4fe1\u53f7\u706f\u7684\u6b63\u786e\u4f7f\u7528\uff0c\u4ec0\u4e48\u4e8b\u4ea4\u901a\u5b89\u5168\u51fa\u884c";
        document.add((IndexableField)new org.apache.lucene.document.Field("content", string, FieldTypes.TYPE_TEXT_WITH_POSITIONS_OFFSETS_NOT_STORED));
        indexWriterAdapter.add(document);
        Closeables.closeQuietly((Closeable)indexWriterAdapter);
        QueryParser queryParser = new QueryParser("content", analyzer);
        Query query = queryParser.parse("content:\"\u4ea4\u901a\u5b89\u5168\u51fa\u884c\"");
        FastVectorHighlighter fastVectorHighlighter = new FastVectorHighlighter(true, true, null, null);
        FieldQuery fieldQuery = fastVectorHighlighter.getFieldQuery(query);
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)rAMDirectory));
            TopDocs topDocs = indexSearcher.search(query, 10);
            Assert.assertEquals((long)1L, (long)topDocs.scoreDocs.length);
            int n = topDocs.scoreDocs[0].doc;
            FieldTermStack fieldTermStack = new FieldTermStack(indexSearcher.getIndexReader(), n, "content", fieldQuery);
            FieldPhraseList fieldPhraseList = new FieldPhraseList(fieldTermStack, fieldQuery);
            Field field = fieldPhraseList.getClass().getDeclaredField("phraseList");
            field.setAccessible(true);
            LinkedList linkedList = (LinkedList)field.get(fieldPhraseList);
            Assert.assertEquals((long)2L, (long)((FieldPhraseList.WeightedPhraseInfo)linkedList.get(0)).getStartOffset());
            Assert.assertEquals((long)8L, (long)((FieldPhraseList.WeightedPhraseInfo)linkedList.get(0)).getEndOffset());
        }
        finally {
            Closeables.closeQuietly((Closeable)indexSearcher.getIndexReader());
        }
    }
}

