/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.search;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sourceforge.docfetcher.model.DocumentType;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.MailResource;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.file.FileFactory;
import net.sourceforge.docfetcher.model.index.outlook.OutlookMailFactory;
import net.sourceforge.docfetcher.model.parse.ChmParser;
import net.sourceforge.docfetcher.model.parse.HtmlParser;
import net.sourceforge.docfetcher.model.parse.PageHandler;
import net.sourceforge.docfetcher.model.parse.PagingChmParser;
import net.sourceforge.docfetcher.model.parse.PagingPdfParser;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.model.parse.PdfParser;
import net.sourceforge.docfetcher.model.parse.TextParser;
import net.sourceforge.docfetcher.model.search.HighlightService;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;

public final class ResultDocument {
    private final Document luceneDoc;
    private final float score;
    private final Query query;
    private final boolean isPhraseQuery;
    private final IndexingConfig config;
    private final FileFactory fileFactory;
    private final OutlookMailFactory mailFactory;
    private final String uid;
    private final boolean isEmail;
    private Path path;
    private Path parentPath;
    private long sizeInKB = -1L;
    private String parserName;

    public ResultDocument(Document document, float f, Query query, boolean bl, IndexingConfig indexingConfig, FileFactory fileFactory, OutlookMailFactory outlookMailFactory) {
        Util.checkNotNull(document, query, indexingConfig, fileFactory, outlookMailFactory);
        this.luceneDoc = document;
        this.score = f;
        this.query = query;
        this.isPhraseQuery = bl;
        this.config = indexingConfig;
        this.fileFactory = fileFactory;
        this.mailFactory = outlookMailFactory;
        this.uid = document.get(Fields.UID.key());
        this.isEmail = DocumentType.isEmailType(this.uid);
    }

    private void onlyFiles() {
        if (this.isEmail) {
            throw new UnsupportedOperationException("Method only supported for file documents.");
        }
    }

    private void onlyEmails() {
        if (!this.isEmail) {
            throw new UnsupportedOperationException("Method only supported for e-mail documents.");
        }
    }

    public String getTitle() {
        String string = this.luceneDoc.get(Fields.TITLE.key());
        if (string == null) {
            string = this.luceneDoc.get(Fields.SUBJECT.key());
        }
        if (string != null && !string.trim().isEmpty()) {
            return string;
        }
        if (this.isEmail) {
            return "";
        }
        return Util.splitFilename(this.getFilename())[0];
    }

    public int getScore() {
        return Math.round(this.score * 100.0f);
    }

    public long getSizeInKB() {
        if (this.sizeInKB < 0L) {
            String string = this.luceneDoc.get(Fields.SIZE.key());
            assert (string != null);
            long l = Long.valueOf(string);
            long l2 = l % 1024L == 0L ? 0L : 1L;
            this.sizeInKB = l / 1024L + l2;
        }
        return this.sizeInKB;
    }

    public String getParserName() {
        if (this.parserName == null) {
            this.parserName = this.luceneDoc.get(Fields.PARSER.key());
        }
        assert (this.parserName != null);
        return this.parserName;
    }

    public String getFilename() {
        if (this.isEmail) {
            return "";
        }
        return this.luceneDoc.get(Fields.FILENAME.key());
    }

    public String getSender() {
        if (!this.isEmail) {
            return "";
        }
        return this.luceneDoc.get(Fields.SENDER.key());
    }

    public String getType() {
        String string = this.luceneDoc.get(Fields.TYPE.key());
        assert (string != null);
        return string;
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = DocumentType.extractPath(this.uid);
        }
        return this.path;
    }

    public String getPathStr() {
        return this.getPath().getPath();
    }

    public Path getParentPath() {
        if (this.parentPath == null) {
            this.parentPath = this.getPath().splitAtLastSeparator().getLeft();
        }
        return this.parentPath;
    }

    public String getAuthors() {
        String[] stringArray = this.luceneDoc.getValues(Fields.AUTHOR.key());
        if (stringArray.length > 0) {
            return Util.join(", ", stringArray);
        }
        String string = this.luceneDoc.get(Fields.SENDER.key());
        return string == null ? "" : string;
    }

    public Date getLastModified() {
        this.onlyFiles();
        String string = this.luceneDoc.get(Fields.LAST_MODIFIED.key());
        return new Date(Long.valueOf(string));
    }

    public String getLastModifiedStr() {
        if (this.isEmail) {
            return "";
        }
        Date date = this.getLastModified();
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(date);
    }

    public Date getDate() {
        this.onlyEmails();
        String string = this.luceneDoc.get(Fields.DATE.key());
        return string == null ? null : new Date(Long.valueOf(string));
    }

    public String getDateStr() {
        if (!this.isEmail) {
            return "";
        }
        Date date = this.getDate();
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(date);
    }

    public boolean isEmail() {
        return this.isEmail;
    }

    public boolean isHtmlFile() {
        return this.wasParsedBy(HtmlParser.class);
    }

    public boolean isPdfFile() {
        return this.wasParsedBy(PdfParser.class);
    }

    public boolean isChmFile() {
        return this.wasParsedBy(ChmParser.class);
    }

    public boolean isPlainTextFile() {
        return this.wasParsedBy(TextParser.class);
    }

    private boolean wasParsedBy(Class<? extends Parser> clazz) {
        String string = this.luceneDoc.get(Fields.PARSER.key());
        return string.equals(clazz.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getText() throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
        this.onlyFiles();
        String string = this.luceneDoc.get(Fields.PARSER.key());
        FileResource fileResource = null;
        try {
            fileResource = this.getFileResource();
            File file = fileResource.getFile();
            String string2 = ParseService.renderText(this.config, file, this.getFilename(), string);
            return string2;
        }
        finally {
            if (fileResource != null) {
                fileResource.dispose();
            }
        }
    }

    public HighlightedString getHighlightedText() throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
        return HighlightService.highlight(this.query, this.isPhraseQuery, this.getText());
    }

    public void readPages(final PreviewPageHandler previewPageHandler) throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
        this.onlyFiles();
        Util.checkNotNull(previewPageHandler);
        FileResource fileResource = null;
        try {
            fileResource = this.getFileResource();
            PageHandler pageHandler = new PageHandler(){

                @Override
                public boolean handlePage(String string) {
                    HighlightedString highlightedString;
                    try {
                        highlightedString = HighlightService.highlight(ResultDocument.this.query, ResultDocument.this.isPhraseQuery, string);
                    }
                    catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
                        throw new OutOfMemoryError(checkedOutOfMemoryError.getMessage());
                    }
                    previewPageHandler.handlePage(highlightedString);
                    return previewPageHandler.isStopped();
                }
            };
            if (this.isPdfFile()) {
                new PagingPdfParser(fileResource.getFile(), pageHandler).run();
            } else if (this.isChmFile()) {
                new PagingChmParser(fileResource.getFile(), pageHandler).run();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
        finally {
            if (fileResource != null) {
                fileResource.dispose();
            }
        }
    }

    public FileResource getFileResource() throws ParseException, FileNotFoundException {
        this.onlyFiles();
        return this.fileFactory.createFile(this.config, this.getPath());
    }

    public MailResource getMailResource() throws ParseException, FileNotFoundException, CheckedOutOfMemoryError {
        this.onlyEmails();
        return this.mailFactory.createMail(this.config, this.query, this.isPhraseQuery, this.getPath());
    }

    public static interface PreviewPageHandler {
        public void handlePage(HighlightedString var1);

        public boolean isStopped();
    }
}

