/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.search;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.IndexLoadingProblems;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.PendingDeletion;
import net.sourceforge.docfetcher.model.index.DecoratedMultiReader;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.file.FileFactory;
import net.sourceforge.docfetcher.model.index.outlook.OutlookMailFactory;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.model.search.DelegatingCollector;
import net.sourceforge.docfetcher.model.search.PhraseDetectingQueryParser;
import net.sourceforge.docfetcher.model.search.ResultDocument;
import net.sourceforge.docfetcher.model.search.SearchException;
import net.sourceforge.docfetcher.model.search.WebQuery;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.collect.LazyList;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;

public final class Searcher {
    private static final int PAGE_SIZE = 50;
    public static final int MAX_RESULTS = ProgramConf.Int.MaxResultsTotal.get();
    private final IndexRegistry indexRegistry;
    private final FileFactory fileFactory;
    private final OutlookMailFactory outlookMailFactory;
    private final Event.Listener<LuceneIndex> addedListener;
    private final BlockingQueue<List<PendingDeletion>> deletionQueue = new LinkedBlockingQueue<List<PendingDeletion>>();
    private final Thread deletionThread;
    private IndexSearcher luceneSearcher;
    private List<LuceneIndex> indexes;
    private volatile IOException ioException;
    private final Lock readLock;
    private final Lock writeLock;
    volatile Boolean stopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Searcher(IndexRegistry indexRegistry, FileFactory fileFactory, OutlookMailFactory outlookMailFactory, final List<IndexLoadingProblems.CorruptedIndex> list) throws IOException {
        Util.checkNotNull(indexRegistry, fileFactory, outlookMailFactory);
        this.indexRegistry = indexRegistry;
        this.fileFactory = fileFactory;
        this.outlookMailFactory = outlookMailFactory;
        this.readLock = indexRegistry.getReadLock();
        this.writeLock = indexRegistry.getWriteLock();
        this.addedListener = new Event.Listener<LuceneIndex>(){

            @Override
            public void update(LuceneIndex luceneIndex) {
                Searcher.this.replaceLuceneSearcher();
            }
        };
        this.writeLock.lock();
        try {
            indexRegistry.addListeners(new IndexRegistry.ExistingIndexesHandler(){

                @Override
                public void handleExistingIndexes(List<LuceneIndex> list2) {
                    try {
                        list.addAll(Searcher.this.setLuceneSearcher(list2));
                    }
                    catch (IOException iOException) {
                        Searcher.this.ioException = iOException;
                    }
                }
            }, this.addedListener, null);
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        this.deletionThread = new Thread(Searcher.class.getName() + " (Approve pending deletions)"){

            @Override
            public void run() {
                try {
                    block2: while (true) {
                        List<PendingDeletion> list = Searcher.this.deletionQueue.take();
                        Searcher.this.replaceLuceneSearcher();
                        Iterator<PendingDeletion> iterator = list.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            PendingDeletion pendingDeletion = iterator.next();
                            pendingDeletion.setApprovedBySearcher();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        this.deletionThread.start();
        this.stopped = true;
    }

    public void replaceLuceneSearcher() {
        this.writeLock.lock();
        try {
            Closeables.close((Closeable)this.luceneSearcher.getIndexReader(), (boolean)false);
            this.setLuceneSearcher(this.indexRegistry.getIndexes());
        }
        catch (IOException iOException) {
            this.ioException = iOException;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private List<IndexLoadingProblems.CorruptedIndex> setLuceneSearcher(List<LuceneIndex> list) throws IOException {
        this.indexes = Util.checkNotNull(list);
        ArrayList<DirectoryReader> arrayList = new ArrayList<DirectoryReader>(list.size());
        LazyList<IndexLoadingProblems.CorruptedIndex> lazyList = new LazyList<IndexLoadingProblems.CorruptedIndex>();
        for (int i = 0; i < list.size(); ++i) {
            LuceneIndex luceneIndex = list.get(i);
            try {
                arrayList.add(DirectoryReader.open((Directory)luceneIndex.getLuceneDir()));
                continue;
            }
            catch (IOException iOException) {
                Util.printErr(iOException);
                lazyList.add(new IndexLoadingProblems.CorruptedIndex(luceneIndex, iOException));
            }
        }
        this.luceneSearcher = new IndexSearcher((IndexReader)new DecoratedMultiReader(arrayList.toArray(new IndexReader[arrayList.size()])));
        return lazyList;
    }

    public List<ResultDocument> search(String string) throws SearchException, CheckedOutOfMemoryError {
        this.stopped = false;
        QueryWrapper queryWrapper = Searcher.createQuery(string);
        Query query = queryWrapper.query;
        boolean bl = queryWrapper.isPhraseQuery;
        this.readLock.lock();
        try {
            this.checkIndexesExist();
            DelegatingCollector delegatingCollector = new DelegatingCollector(){

                @Override
                public void collect(int n) throws IOException {
                    this.leafDelegate.collect(n);
                    if (Searcher.this.stopped.booleanValue()) {
                        throw new StoppedSearcherException();
                    }
                }
            };
            delegatingCollector.setDelegate((Collector)TopScoreDocCollector.create((int)MAX_RESULTS, null));
            try {
                this.luceneSearcher.search(query, (Collector)delegatingCollector);
            }
            catch (StoppedSearcherException stoppedSearcherException) {
                // empty catch block
            }
            ScoreDoc[] scoreDocArray = ((TopScoreDocCollector)delegatingCollector.getDelegate()).topDocs().scoreDocs;
            ResultDocument[] resultDocumentArray = new ResultDocument[scoreDocArray.length];
            for (int i = 0; i < scoreDocArray.length; ++i) {
                Document document = this.luceneSearcher.doc(scoreDocArray[i].doc);
                float f = scoreDocArray[i].score;
                LuceneIndex luceneIndex = this.indexes.get(((DecoratedMultiReader)this.luceneSearcher.getIndexReader()).decoratedReaderIndex(i));
                IndexingConfig indexingConfig = luceneIndex.getConfig();
                resultDocumentArray[i] = new ResultDocument(document, f, query, bl, indexingConfig, this.fileFactory, this.outlookMailFactory);
            }
            List<ResultDocument> list = Arrays.asList(resultDocumentArray);
            return list;
        }
        catch (IOException iOException) {
            throw new SearchException(iOException.getMessage());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopSearch() {
        this.stopped = true;
    }

    public List<ResultDocument> list(Set<String> set) throws SearchException, CheckedOutOfMemoryError {
        String string3;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        ArrayList<Term> arrayList = new ArrayList<Term>(set.size());
        String string2 = Fields.UID.key();
        for (String string3 : set) {
            arrayList.add(new Term(string2, string3));
        }
        TermsQuery termsQuery = new TermsQuery(arrayList);
        builder.add((Query)termsQuery, BooleanClause.Occur.FILTER);
        string3 = new MatchAllDocsQuery();
        this.readLock.lock();
        try {
            this.checkIndexesExist();
            builder.add((Query)string3, BooleanClause.Occur.MUST);
            ScoreDoc[] scoreDocArray = this.luceneSearcher.search((Query)builder.build(), (int)Searcher.MAX_RESULTS).scoreDocs;
            ResultDocument[] resultDocumentArray = new ResultDocument[scoreDocArray.length];
            for (int i = 0; i < resultDocumentArray.length; ++i) {
                Document document = this.luceneSearcher.doc(scoreDocArray[i].doc);
                float f = scoreDocArray[i].score;
                LuceneIndex luceneIndex = this.indexes.get(((DecoratedMultiReader)this.luceneSearcher.getIndexReader()).decoratedReaderIndex(i));
                IndexingConfig indexingConfig = luceneIndex.getConfig();
                resultDocumentArray[i] = new ResultDocument(document, f, (Query)string3, true, indexingConfig, this.fileFactory, this.outlookMailFactory);
            }
            Arrays.sort(resultDocumentArray, new Comparator<ResultDocument>(){

                @Override
                public int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                    return AlphanumComparator.ignoreCaseInstance.compare(resultDocument.getTitle(), resultDocument2.getTitle());
                }
            });
            List<ResultDocument> list = Arrays.asList(resultDocumentArray);
            return list;
        }
        catch (IOException iOException) {
            throw new SearchException(iOException.getMessage());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ResultPage search(WebQuery webQuery) throws IOException, SearchException, CheckedOutOfMemoryError {
        ScoreDoc[] scoreDocArray;
        String string;
        Object object;
        Object object2;
        Util.checkNotNull(webQuery);
        if (this.ioException != null) {
            throw this.ioException;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (webQuery.minSize != null || webQuery.maxSize != null) {
            builder.add((Query)LegacyNumericRangeQuery.newLongRange((String)Fields.SIZE.key(), (Long)webQuery.minSize, (Long)webQuery.maxSize, (boolean)true, (boolean)true), BooleanClause.Occur.FILTER);
        }
        if (webQuery.parsers != null) {
            object2 = new ArrayList(webQuery.parsers.size() + 1);
            object = Fields.PARSER.key();
            ((ArrayList)object2).add(new Term((String)object, "EmailParser"));
            for (Parser outOfMemoryError : webQuery.parsers) {
                string = outOfMemoryError.getClass().getSimpleName();
                ((ArrayList)object2).add(new Term((String)object, string));
            }
            builder.add((Query)new TermsQuery((Collection)object2), BooleanClause.Occur.FILTER);
        }
        if (webQuery.indexes != null) {
            object2 = new BooleanQuery.Builder();
            for (LuceneIndex luceneIndex : webQuery.indexes) {
                Path path = luceneIndex.getRootFolder().getPath();
                string = luceneIndex.getDocumentType().createUniqueId(path);
                scoreDocArray = new Term(Fields.UID.key(), string + "/");
                object2.add((Query)new PrefixQuery((Term)scoreDocArray), BooleanClause.Occur.SHOULD);
            }
            builder.add((Query)object2.build(), BooleanClause.Occur.FILTER);
        }
        object2 = Searcher.createQuery(webQuery.query);
        object = ((QueryWrapper)object2).query;
        boolean bl = ((QueryWrapper)object2).isPhraseQuery;
        this.readLock.lock();
        try {
            Object object3;
            int n;
            int n2;
            this.checkIndexesExist();
            int n3 = (webQuery.pageIndex + 1) * 50;
            builder.add((Query)object, BooleanClause.Occur.MUST);
            string = this.luceneSearcher.search((Query)builder.build(), n3);
            scoreDocArray = ((TopDocs)string).scoreDocs;
            int n4 = scoreDocArray.length;
            int n5 = n4 <= 50 ? 0 : n4 - ((n2 = n4 % 50) == 0 ? 50 : n2);
            ResultDocument[] resultDocumentArray = new ResultDocument[n4 - n5];
            for (n = n5; n < n4; ++n) {
                Document document = this.luceneSearcher.doc(scoreDocArray[n].doc);
                float f = scoreDocArray[n].score;
                object3 = this.indexes.get(((DecoratedMultiReader)this.luceneSearcher.getIndexReader()).decoratedReaderIndex(n));
                IndexingConfig indexingConfig = object3.getConfig();
                resultDocumentArray[n - n5] = new ResultDocument(document, f, (Query)object, bl, indexingConfig, this.fileFactory, this.outlookMailFactory);
            }
            n = ((TopDocs)string).totalHits;
            int n6 = n5 / 50;
            int n7 = (int)Math.ceil((float)n / 50.0f);
            object3 = new ResultPage(Arrays.asList(resultDocumentArray), n6, n7, n);
            return object3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CheckedOutOfMemoryError(outOfMemoryError);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static QueryWrapper createQuery(String string) throws SearchException {
        PhraseDetectingQueryParser phraseDetectingQueryParser = new PhraseDetectingQueryParser(Fields.CONTENT.key(), IndexRegistry.getAnalyzer());
        phraseDetectingQueryParser.setAllowLeadingWildcard(true);
        MultiTermQuery.RewriteMethod rewriteMethod = MultiTermQuery.SCORING_BOOLEAN_REWRITE;
        phraseDetectingQueryParser.setMultiTermRewriteMethod(rewriteMethod);
        if (!SettingsConf.Bool.UseOrOperator.get()) {
            phraseDetectingQueryParser.setDefaultOperator(QueryParser.AND_OPERATOR);
        }
        try {
            Query query = phraseDetectingQueryParser.parse(string);
            boolean bl = phraseDetectingQueryParser.isPhraseQuery();
            return new QueryWrapper(query, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = Msg.invalid_query.get() + "\n\n" + illegalArgumentException.getMessage();
            throw new SearchException(string2);
        }
        catch (ParseException parseException) {
            String string3 = Msg.invalid_query.get() + "\n\n" + parseException.getMessage();
            throw new SearchException(string3);
        }
    }

    private void checkIndexesExist() throws SearchException {
        if (this.indexes.isEmpty()) {
            throw new SearchException("Nothing to search in: No indexes have been created yet.");
        }
        for (LuceneIndex luceneIndex : this.indexes) {
            File file = luceneIndex.getIndexDirPath().getCanonicalFile();
            if (file == null || file.isDirectory()) continue;
            Object object = "Folders not found:";
            object = (String)object + "\n" + file;
            throw new SearchException((String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void approveDeletions(List<PendingDeletion> list) {
        Util.checkNotNull(list);
        if (list.isEmpty()) {
            return;
        }
        Searcher searcher = this;
        synchronized (searcher) {
            if (this.deletionThread.isInterrupted()) {
                for (PendingDeletion pendingDeletion : list) {
                    pendingDeletion.setApprovedBySearcher();
                }
            } else {
                this.deletionQueue.add(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.ioException != null) {
            Util.printErr(this.ioException);
        }
        this.writeLock.lock();
        try {
            this.indexRegistry.removeListeners(this.addedListener, null);
            Closeables.closeQuietly((Closeable)this.luceneSearcher.getIndexReader());
        }
        finally {
            this.writeLock.unlock();
        }
        Searcher searcher = this;
        synchronized (searcher) {
            this.deletionThread.interrupt();
        }
    }

    private static final class QueryWrapper {
        public final Query query;
        public final boolean isPhraseQuery;

        private QueryWrapper(Query query, boolean bl) {
            this.query = Util.checkNotNull(query);
            this.isPhraseQuery = bl;
        }
    }

    private class StoppedSearcherException
    extends RuntimeException {
        private StoppedSearcherException() {
        }
    }

    public static final class ResultPage {
        public final List<ResultDocument> resultDocuments;
        public final int pageIndex;
        public final int pageCount;
        public final int hitCount;

        private ResultPage(List<ResultDocument> list, int n, int n2, int n3) {
            this.resultDocuments = Util.checkNotNull(list);
            this.pageIndex = n;
            this.pageCount = n2;
            this.hitCount = n3;
        }
    }
}

