/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;

public final class ConfLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<Loadable> load(File file, Class<?> clazz, boolean bl) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            if (bl) {
                file.createNewFile();
            } else {
                throw new FileNotFoundException();
            }
        }
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileLock fileLock = fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
        bufferedInputStream = new BufferedInputStream(fileInputStream);
        List<Loadable> list = ConfLoader.load(bufferedInputStream, clazz);
        fileLock.release();
        Closeables.closeQuietly((Closeable)bufferedInputStream);
        return list;
        {
            catch (Throwable throwable) {
                try {
                    fileLock.release();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Closeables.closeQuietly(bufferedInputStream);
                    throw throwable2;
                }
            }
        }
    }

    public static List<Loadable> load(InputStream inputStream, Class<?> clazz) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
        Properties properties = new Properties();
        properties.load(inputStreamReader);
        ArrayList<Loadable> arrayList = new ArrayList<Loadable>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Class clazz2 : ConfLoader.getEnums(clazz)) {
            for (Loadable loadable : (Loadable[])clazz2.getEnumConstants()) {
                String string;
                String string2 = loadable.name();
                if (hashSet.contains(string2)) {
                    string = String.format("Class %s contains duplicate enum entry '%s.%s'.", clazz.getName(), clazz2.getSimpleName(), string2);
                    throw new IllegalStateException(string);
                }
                hashSet.add(string2);
                string = properties.getProperty(string2);
                if (string == null) {
                    arrayList.add(loadable);
                    continue;
                }
                try {
                    loadable.load(string);
                }
                catch (Exception exception) {
                    arrayList.add(loadable);
                }
            }
        }
        return arrayList;
    }

    private static <T> List<Class<? extends T>> getEnums(Class<?> clazz) {
        Class<?>[] classArray;
        ArrayList arrayList = Lists.newArrayList();
        for (Class<?> clazz2 : classArray = clazz.getDeclaredClasses()) {
            if (!clazz2.isEnum()) continue;
            Class<?>[] classArray2 = clazz2.getInterfaces();
            assert (classArray2.length == 1);
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    public static String getRawValue(String string, Class<?> clazz) {
        for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
            if (!clazz2.isEnum()) continue;
            Class<?>[] classArray = clazz2.getInterfaces();
            assert (classArray.length == 1);
            Class<?> clazz3 = clazz2;
            for (Storable storable : (Storable[])clazz3.getEnumConstants()) {
                if (!storable.name().equals(string)) continue;
                return storable.valueToString();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, Class<?> clazz, String string) throws IOException {
        boolean bl = Util.IS_WINDOWS || AppUtil.isPortable();
        String string2 = bl ? "\r\n" : "\n";
        string = bl ? Util.ensureWindowsLineSep(string.trim()) : Util.ensureLinuxLineSep(string.trim());
        BufferedWriter bufferedWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            FileLock fileLock = fileOutputStream.getChannel().lock();
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8"));
                bufferedWriter.write(string);
                bufferedWriter.write(string2);
                bufferedWriter.write("#");
                bufferedWriter.write(string2);
                bufferedWriter.write("# ");
                bufferedWriter.write(new Date().toString());
                bufferedWriter.write(string2);
                bufferedWriter.write(string2);
                int n = 0;
                for (Class clazz2 : ConfLoader.getEnums(clazz)) {
                    Storable[] storableArray = (Storable[])clazz2.getEnumConstants();
                    if (storableArray.length == 0) continue;
                    if (n++ > 0) {
                        bufferedWriter.write(string2);
                        bufferedWriter.write(string2);
                    }
                    String string3 = clazz2.getAnnotation(Description.class).value();
                    string3 = bl ? Util.ensureWindowsLineSep(string3) : Util.ensureLinuxLineSep(string3);
                    bufferedWriter.write(string3);
                    bufferedWriter.write(string2);
                    int n2 = 0;
                    for (Storable storable : storableArray) {
                        if (n2++ > 0) {
                            bufferedWriter.write(string2);
                        }
                        String string4 = ConfLoader.convert(storable.name(), true);
                        String string5 = ConfLoader.convert(storable.valueToString(), false);
                        bufferedWriter.write(string4 + " = " + string5);
                    }
                }
            }
            finally {
                fileLock.release();
            }
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(bufferedWriter);
            throw throwable;
        }
        Closeables.closeQuietly((Closeable)bufferedWriter);
    }

    public static String convert(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadFromStreamOrFile(Class<?> clazz, Class<?> clazz2, String string, String string2) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        try {
            ConfLoader.load(inputStream, clazz2);
        }
        catch (Exception exception) {
            try {
                ConfLoader.load(new File(string2), clazz2, false);
            }
            catch (Exception exception2) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
        return true;
    }

    private ConfLoader() {
    }

    public static interface Loadable {
        public String name();

        public void load(String var1);
    }

    public static interface Storable
    extends Loadable {
        public String valueToString();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Description {
        public String value();
    }
}

