/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

public abstract class Stoppable<T extends Throwable> {
    private boolean stopped = false;
    private T t;

    public final boolean isStopped() {
        return this.stopped;
    }

    public final void stop() {
        this.stopped = true;
    }

    public final void stop(T t) {
        this.stopped = true;
        this.t = t;
    }

    public final void run() throws T {
        try {
            this.doRun();
        }
        finally {
            this.runFinally();
        }
        if (this.t != null) {
            throw this.t;
        }
    }

    public final void runSilently() {
        this.doRun();
        this.runFinally();
    }

    protected abstract void doRun();

    protected void runFinally() {
    }
}

