/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.WString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public final class Util {
    public static final boolean IS_WINDOWS;
    public static final boolean IS_LINUX;
    public static final boolean IS_LINUX_KDE;
    public static final boolean IS_UBUNTU_UNITY;
    public static final boolean IS_MAC_OS_X;
    public static final boolean IS_64_BIT_JVM;
    public static final File TEMP_DIR;
    public static final String USER_DIR_PATH;
    public static final File USER_DIR;
    public static final String USER_HOME_PATH;
    public static final String LS;
    public static final String FS;
    public static final CharMatcher fileSepMatcher;
    private static Kernel32 lib;
    private static Pattern drivePattern;
    private static Pattern driveOnlyPattern;
    private static long lastTimeStamp;

    private Util() {
    }

    private static boolean isUbuntuUnity(boolean bl) {
        if (!bl) {
            return false;
        }
        try {
            String string = Util.getProcessOutput("lsb_release -irs").trim();
            String[] stringArray = string.split("\n");
            if (stringArray.length != 2) {
                return false;
            }
            if (!stringArray[0].trim().toLowerCase().equals("ubuntu")) {
                return false;
            }
            if (stringArray[1].trim().equals("11.04")) {
                return "gnome".equals(System.getenv("DESKTOP_SESSION")) && "gnome".equals(System.getenv("GDMSESSION"));
            }
            return "Unity".equals(System.getenv("XDG_CURRENT_DESKTOP"));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String getProcessOutput(String string) throws IOException {
        String string2;
        Process process = Runtime.getRuntime().exec(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(LS);
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static int[] toIntArray(String string, int[] nArray) {
        if (string.trim().equals("")) {
            return new int[0];
        }
        String[] stringArray = string.split("[^-\\d]+");
        int[] nArray2 = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray2[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (stringArray[i].matches("\\d{10,}")) {
                    nArray2[i] = Integer.MAX_VALUE;
                    continue;
                }
                if (stringArray[i].matches("-\\d{10,}")) {
                    nArray2[i] = Integer.MIN_VALUE;
                    continue;
                }
                return nArray;
            }
        }
        return nArray2;
    }

    public static int toInt(String string, int n) {
        string = string.trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches("\\d{10,}")) {
                return Integer.MAX_VALUE;
            }
            if (string.matches("-\\d{10,}")) {
                return Integer.MIN_VALUE;
            }
            return n;
        }
    }

    public static String encodeStrings(String string, Collection<String> collection) {
        Util.checkNotNull(string, collection);
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : collection) {
            if (!bl) {
                stringBuilder.append(string);
            }
            stringBuilder.append(string2.replace("\\", "\\\\").replace(string, "\\" + string));
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static List<String> decodeStrings(char c, String string) {
        Util.checkNotNull(string);
        if (string.trim().isEmpty()) {
            return new ArrayList<String>(0);
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c && !bl) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.length());
            } else if (c2 != '\\' || bl) {
                stringBuilder.append(c2);
            }
            bl = c2 == '\\' ? !bl : false;
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    public static String encodeBase64(String string) {
        String string2 = Base64.encodeBase64URLSafeString((byte[])string.getBytes());
        return new String(string2);
    }

    public static String truncate(String string) {
        if (string.length() > 32) {
            return string.substring(0, 32) + "...";
        }
        return string;
    }

    public static String trimLeft(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return string.substring(i);
        }
        return "";
    }

    public static String trimRight(String string) {
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    public static Map<Integer, int[]> createLineMap(String string, int[] nArray) {
        Object object;
        Util.checkThat(nArray.length % 2 == 0);
        if (nArray.length == 0) {
            return Collections.emptyMap();
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < nArray.length / 2; ++i) {
            object = new int[]{nArray[i * 2], nArray[i * 2 + 1]};
            arrayList.add(new SpanObject<Object>(object, (int)object[0], (int)object[1]));
        }
        final HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
        object = new LineMap<int[]>(){

            @Override
            public void add(int n, int[] nArray) {
                int[] nArray2 = (int[])hashMap.get(n);
                if (nArray2 == null) {
                    hashMap.put(n, nArray);
                } else {
                    int[] nArray3 = new int[nArray2.length + nArray.length];
                    System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                    System.arraycopy(nArray, 0, nArray3, nArray2.length, nArray.length);
                    hashMap.put(n, nArray3);
                }
            }
        };
        Util.createLineMap(string, arrayList, object);
        return hashMap;
    }

    private static <A> void createLineMap(String string, Collection<SpanObject<A>> collection, LineMap<A> lineMap) {
        if (collection.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (SpanObject<A> spanObject : collection) {
            int n3 = spanObject.start;
            int n4 = spanObject.end;
            if (0 > n3 || n4 > string.length()) continue;
            assert (n3 <= n4);
            int n5 = n += Util.lineCount(string, n2, n3) - 1;
            n += Util.lineCount(string, n3, n4) - 1;
            for (int i = n5; i <= n; ++i) {
                lineMap.add(i, spanObject.object);
            }
            n2 = n4;
        }
    }

    private static int lineCount(String string, int n, int n2) {
        int n3 = 1;
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (bl) {
                ++n3;
                if (c == '\r') continue;
                bl = false;
                continue;
            }
            if (c == '\r') {
                bl = true;
                continue;
            }
            if (c != '\n') continue;
            ++n3;
        }
        if (bl) {
            ++n3;
        }
        return n3;
    }

    public static <T> boolean equals(Collection<T> collection, T[] TArray) {
        Util.checkNotNull(collection, TArray);
        if (collection.size() != TArray.length) {
            return false;
        }
        int n = 0;
        for (T t : collection) {
            if (!t.equals(TArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String ensureLinuxLineSep(String string) {
        return string.replaceAll("\r\n?", "\n");
    }

    public static String ensureWindowsLineSep(String string) {
        return string.replaceAll("\r\n?", "\n").replace("\n", "\r\n");
    }

    public static List<String> splitPath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '/' && c != '\\') continue;
            arrayList.add(string.substring(n, i));
            n = i + 1;
        }
        if (n < string.length()) {
            arrayList.add(string.substring(n));
        }
        return arrayList;
    }

    public static String joinPath(String string, String string2, String ... stringArray) {
        if (stringArray.length == 0) {
            if (string.isEmpty()) {
                return string2;
            }
            if (string2.isEmpty()) {
                return string;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fileSepMatcher.trimTrailingFrom((CharSequence)string));
        stringBuilder.append('/');
        stringBuilder.append(fileSepMatcher.trimFrom((CharSequence)string2));
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append('/');
            stringBuilder.append(fileSepMatcher.trimFrom((CharSequence)stringArray[i]));
        }
        return Util.toForwardSlashes(stringBuilder.toString());
    }

    public static String joinPath(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fileSepMatcher.trimTrailingFrom((CharSequence)iterator.next().toString()));
        while (iterator.hasNext()) {
            stringBuilder.append('/');
            stringBuilder.append(fileSepMatcher.trimFrom((CharSequence)iterator.next().toString()));
        }
        return Util.toForwardSlashes(stringBuilder.toString());
    }

    public static String join(String string, Object ... objectArray) {
        Util.checkNotNull(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append(objectArray[i]);
                continue;
            }
            stringBuilder.append(string);
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Iterable<?> iterable) {
        Util.checkNotNull(string);
        Iterator<?> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iterator.next().toString());
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next().toString());
        }
        return stringBuilder.toString();
    }

    public static String getAbsPath(File file) {
        String string = file.getAbsolutePath();
        if (string.startsWith("\\\\")) {
            return string;
        }
        return string.replace('\\', '/').replace("//", "/");
    }

    public static boolean isUncPath(File file) {
        return file.getPath().startsWith("\\\\");
    }

    public static String getAbsPath(String string) {
        return Util.getAbsPath(new File(string));
    }

    public static File getAbsFile(File file) {
        return new File(Util.getAbsPath(file));
    }

    public static String getSystemAbsPath(File file) {
        return file.getAbsolutePath();
    }

    public static String getSystemAbsPath(String string) {
        return new File(string).getAbsolutePath();
    }

    public static File getCanonicalFile(String string) {
        return Util.getCanonicalFile(new File(string));
    }

    public static File getCanonicalFile(File file) {
        return new File(Util.getCanonicalPath(file));
    }

    public static String getCanonicalPath(File file) {
        if (IS_WINDOWS && Util.isWindowsDevice(file.getPath())) {
            String string = Util.getDriveLetter(file.getPath());
            assert (string != null);
            return string + ":\\";
        }
        return file.getAbsolutePath();
    }

    public static boolean isCanonicallyEqual(File file, File file2) {
        if (file == null || file2 == null) {
            return false;
        }
        return Util.getCanonicalFile(file).equals(Util.getCanonicalFile(file2));
    }

    public static File[] listFiles(File file) {
        File[] fileArray = file.listFiles();
        return fileArray == null ? new File[]{} : fileArray;
    }

    public static File[] listFiles(File file, FilenameFilter filenameFilter) {
        File[] fileArray = file.listFiles(filenameFilter);
        return fileArray == null ? new File[]{} : fileArray;
    }

    public static File[] listFiles(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles(fileFilter);
        return fileArray == null ? new File[]{} : fileArray;
    }

    public static boolean isSymLink(File file) {
        try {
            File file2;
            if (file.getParent() == null) {
                file2 = file;
            } else {
                File file3 = file.getParentFile().getCanonicalFile();
                file2 = new File(file3, file.getName());
            }
            return !file2.getCanonicalFile().equals(file2.getAbsoluteFile());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int getWin32FileAttributes(File file) throws IOException {
        Object object;
        if (lib == null) {
            object = Kernel32.class;
            // MONITORENTER : net.sourceforge.docfetcher.util.Util$Kernel32.class
            lib = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
            // MONITOREXIT : object
        }
        try {
            object = file.getCanonicalPath();
            return lib.GetFileAttributesW(new WString((String)object));
        }
        catch (IOException iOException) {
            object = file.getAbsolutePath();
        }
        return lib.GetFileAttributesW(new WString((String)object));
    }

    public static boolean isJunctionOrSymlink(File file) {
        if (!IS_WINDOWS) {
            return false;
        }
        try {
            return new File(file.getPath()).exists() && (0x400 & Util.getWin32FileAttributes(file)) != 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static File getParentFile(File file) {
        Util.checkNotNull(file);
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        }
        return file2;
    }

    public static String toForwardSlashes(String string) {
        if (string.startsWith("\\\\")) {
            return string;
        }
        return string.replace('\\', '/');
    }

    public static File getParentFile(String string) {
        Util.checkNotNull(string);
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        }
        return file2;
    }

    public static boolean containsEquality(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return false;
        }
        for (Object object2 : objectArray) {
            if (!object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static String[] splitFilename(File file) {
        return Util.splitFilename(file.getName());
    }

    public static String[] splitFilename(String string) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return new String[]{string, ""};
        }
        String string2 = string.substring(n2 + 1).toLowerCase();
        if (string2.equals("gz") && (n = string.lastIndexOf(46, n2 - 1)) != -1) {
            return new String[]{string.substring(0, n), string.substring(n + 1).toLowerCase()};
        }
        return new String[]{string.substring(0, n2), string2};
    }

    public static String getExtension(String string) {
        return Util.splitFilename(string)[1];
    }

    public static String getExtension(File file) {
        return Util.splitFilename(file.getName())[1];
    }

    public static boolean hasExtension(String string, String ... stringArray) {
        string = string.toLowerCase();
        for (String string2 : stringArray) {
            if (!string.endsWith("." + string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(String string, Collection<String> collection) {
        string = string.toLowerCase();
        for (String string2 : collection) {
            if (!string.endsWith("." + string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static void deleteContents(File file) throws IOException {
        Util.checkThat(file.isDirectory());
        if (Util.isSymLink(file)) {
            return;
        }
        for (File file2 : Util.listFiles(file)) {
            Util.deleteRecursively(file2);
        }
    }

    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            Util.deleteContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    public static String getNameOrLetter(File file, String string) {
        String string2;
        Util.checkNotNull(file, string);
        String string3 = file.getName();
        if (file.getAbsoluteFile().equals(USER_DIR)) {
            return USER_DIR.getName();
        }
        if (IS_WINDOWS && string3.length() == 0 && Util.getParentFile(file) == null && (string2 = Util.getDriveLetter(file.getPath())) != null) {
            return string2 + string;
        }
        return string3;
    }

    public static String getDriveLetter(String string) {
        Util.checkNotNull(string);
        Matcher matcher = drivePattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1).toUpperCase();
        }
        return null;
    }

    public static boolean isWindowsDevice(String string) {
        return driveOnlyPattern.matcher(string).matches();
    }

    public static void checkThat(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkThat(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }

    public static <T> T checkNotNull(T t) {
        if (t instanceof Boolean) {
            throw new UnsupportedOperationException();
        }
        if (t == null) {
            throw new IllegalArgumentException();
        }
        return t;
    }

    public static void checkNotNull(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkNotNull(Object object, Object object2, Object object3) {
        if (object == null || object2 == null || object3 == null) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkNotNull(Object object, Object object2, Object object3, Object object4) {
        if (object == null || object2 == null || object3 == null || object4 == null) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkNotNull(Object object, Object object2, Object object3, Object object4, Object object5) {
        if (object == null || object2 == null || object3 == null || object4 == null || object5 == null) {
            throw new IllegalArgumentException();
        }
    }

    public static String notNull(String string) {
        return string == null ? "" : string;
    }

    public static synchronized long getTimestamp() {
        long l = System.currentTimeMillis();
        while (l == lastTimeStamp) {
            l = System.currentTimeMillis();
        }
        lastTimeStamp = l;
        return l;
    }

    public static boolean contains(File file, File file2) {
        return Util.contains(Util.getAbsPath(file), Util.getAbsPath(file2));
    }

    public static boolean contains(String string, String string2) {
        string = string.replace('\\', '/');
        string2 = string2.replace('\\', '/');
        if (string.length() >= string2.length()) {
            return false;
        }
        char c = string2.charAt(string.length());
        if (c != '/') {
            return false;
        }
        return string2.startsWith(string);
    }

    public static <T> T getLast(List<T> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        return list.get(n - 1);
    }

    @SafeVarargs
    public static <T> List<T> createList(int n, T ... TArray) {
        Util.checkNotNull(TArray);
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length + n);
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    @SafeVarargs
    public static <T> List<T> createList(Collection<? extends T> collection, T ... TArray) {
        Util.checkNotNull(collection, TArray);
        ArrayList<T> arrayList = new ArrayList<T>(collection.size() + TArray.length);
        arrayList.addAll(collection);
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    @SafeVarargs
    public static <T> List<T> createListReversed(Collection<? extends T> collection, T ... TArray) {
        Util.checkNotNull(collection, TArray);
        ArrayList<T> arrayList = new ArrayList<T>(collection.size() + TArray.length);
        for (T t : TArray) {
            arrayList.add(t);
        }
        arrayList.addAll(collection);
        return arrayList;
    }

    public static <T> List<T> createEmptyList(Collection<?> ... collectionArray) {
        int n = 0;
        for (int i = 0; i < collectionArray.length; ++i) {
            n += collectionArray[i].size();
        }
        return new ArrayList(n);
    }

    public static File createTempDir() throws IOException {
        File file = Files.createTempDir();
        return IS_WINDOWS || IS_MAC_OS_X ? file.getCanonicalFile() : file;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return Util.createTempFile(string, string2, null);
    }

    public static File createTempFile(String object, String string, File file) throws IOException {
        int n = ((String)object).length();
        if (n < 3) {
            object = (String)object + Strings.repeat((String)"_", (int)(3 - n));
        }
        File file2 = File.createTempFile((String)object, string, file);
        if (IS_MAC_OS_X) {
            file2 = file2.getCanonicalFile();
        }
        file2.deleteOnExit();
        return file2;
    }

    public static File createDerivedTempFile(String string, File file) throws IOException {
        String[] stringArray = Util.splitFilename(string);
        if (!stringArray[1].equals("")) {
            stringArray[1] = "." + stringArray[1];
        }
        return Util.createTempFile(stringArray[0], stringArray[1], file);
    }

    public static void println(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Object object : objectArray) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("; ");
            }
            stringBuilder.append(object);
        }
        System.out.println(stringBuilder.toString());
    }

    public static void printErr(String string) {
        System.err.println(string);
    }

    public static void printErr(Throwable throwable) {
        throwable.printStackTrace();
    }

    public static String getLowestMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        List list = Throwables.getCausalChain((Throwable)throwable);
        for (Throwable throwable2 : Lists.reverse((List)list)) {
            String string = throwable2.getMessage();
            if (string == null || string.trim().equals("")) continue;
            return string;
        }
        return "";
    }

    public static int clamp(int n, int n2, int n3) {
        Util.checkThat(n2 <= n3);
        if (n > n3) {
            return n3;
        }
        if (n < n2) {
            return n2;
        }
        return n;
    }

    public static boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public static boolean winOpenDir(String string) {
        if (IS_WINDOWS) {
            try {
                Runtime.getRuntime().exec("explorer /select, " + string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static String getDefaultIndexName(File file) {
        String string = Util.getNameOrLetter(file, ":\\");
        return Util.truncate(string);
    }

    static {
        TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
        USER_DIR_PATH = Util.toForwardSlashes(System.getProperty("user.dir"));
        USER_DIR = new File(USER_DIR_PATH);
        USER_HOME_PATH = System.getProperty("user.home");
        LS = System.getProperty("line.separator");
        FS = System.getProperty("file.separator");
        String string = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = string.contains("windows");
        IS_LINUX = string.contains("linux");
        IS_UBUNTU_UNITY = Util.isUbuntuUnity(IS_LINUX);
        IS_LINUX_KDE = IS_LINUX && System.getenv("KDE_FULL_SESSION") != null;
        IS_MAC_OS_X = string.equals("mac os x");
        String string2 = System.getProperty("sun.arch.data.model");
        if (string2 == null) {
            string2 = System.getProperty("os.arch").toLowerCase();
        }
        IS_64_BIT_JVM = string2.contains("64");
        fileSepMatcher = CharMatcher.anyOf((CharSequence)"/\\").precomputed();
        lib = null;
        drivePattern = Pattern.compile("([a-zA-Z]):.*");
        driveOnlyPattern = Pattern.compile("(?:[a-zA-Z]):(?:\\\\|/)*");
        lastTimeStamp = -1L;
    }

    private static final class SpanObject<A> {
        public final A object;
        public final int start;
        public final int end;

        public SpanObject(A a, int n, int n2) {
            this.object = a;
            this.start = n;
            this.end = n2;
        }
    }

    private static interface LineMap<A> {
        public void add(int var1, A var2);
    }

    private static interface Kernel32
    extends Library {
        public int GetFileAttributesW(WString var1);
    }
}

