/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.ManualLocator;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.gui.Col;
import net.sourceforge.docfetcher.util.gui.dialog.InfoDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class UtilGui {
    public static final int BTW = 75;
    private static KeyListener selectAllKeyListener;
    public static final int DIALOG_STYLE = 36080;

    private UtilGui() {
    }

    public static boolean isDarkTheme() {
        Color color = Display.getCurrent().getSystemColor(25);
        return !UtilGui.isMoreWhite(color);
    }

    public static boolean isMoreWhite(Color color) {
        int n;
        int n2;
        int n3 = color.getRed();
        return (0.299 * (double)n3 + 0.587 * (double)(n2 = color.getGreen()) + 0.114 * (double)(n = color.getBlue())) / 255.0 > 0.5;
    }

    public static void setBackground(Control control, int n) {
        control.setBackground(control.getDisplay().getSystemColor(n));
    }

    public static void setForeground(Control control, int n) {
        control.setForeground(control.getDisplay().getSystemColor(n));
    }

    public static void setLinkForeground(Link link, int n) {
        link.setLinkForeground(link.getDisplay().getSystemColor(n));
    }

    public static Color getTextForeground(Color color) {
        return UtilGui.isMoreWhite(color) ? Col.BLACK.get() : Col.WHITE.get();
    }

    public static int getTextForegroundInt(Color color) {
        return UtilGui.isMoreWhite(color) ? 2 : 1;
    }

    public static void setForegroundFromBackground(Control control) {
        Color color = control.getBackground();
        int n = UtilGui.getTextForegroundInt(color);
        UtilGui.setForeground(control, n);
    }

    public static void paintBorder(final Control control) {
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Point point = control.getSize();
                paintEvent.gc.setForeground(Col.WIDGET_NORMAL_SHADOW.get());
                paintEvent.gc.drawRectangle(0, 0, point.x - 1, point.y - 1);
                paintEvent.gc.setForeground(Col.WIDGET_LIGHT_SHADOW.get());
                paintEvent.gc.drawRectangle(1, 1, point.x - 3, point.y - 3);
            }
        });
    }

    public static void clearSelectionOnFocusLost(final StyledText styledText) {
        styledText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                styledText.setSelection(0);
            }
        });
    }

    public static void hideCaretAndSelection(StyledText styledText) {
        styledText.setCaret(null);
        styledText.setEditable(false);
        styledText.setCursor(styledText.getDisplay().getSystemCursor(0));
        styledText.setSelectionBackground(styledText.getBackground());
        styledText.setSelectionForeground(styledText.getForeground());
    }

    public static void setGridData(Control control, boolean bl) {
        control.setLayoutData((Object)new GridData(4, 4, true, bl));
    }

    public static void showOutOfMemoryMessage(Control control, CheckedOutOfMemoryError checkedOutOfMemoryError) {
        UtilGui.showOutOfMemoryMessage(control, checkedOutOfMemoryError.getCause());
    }

    public static void showOutOfMemoryMessage(final Control control, Throwable throwable) {
        Util.printErr(throwable);
        UtilGui.runSwtSafe((Widget)control, new Runnable(){

            @Override
            public void run() {
                String string = ManualLocator.getManualSubpageUrl("Memory_Limit.html");
                if (string == null) {
                    string = "???";
                }
                InfoDialog infoDialog = new InfoDialog(control.getShell());
                infoDialog.setTitle(Msg.out_of_memory.get());
                infoDialog.setImage(1);
                infoDialog.setText(Msg.out_of_memory_instructions.format(string));
                infoDialog.open();
            }
        });
    }

    public static SettingsConf.FontDescription getPreviewFontNormal() {
        if (Util.IS_WINDOWS) {
            return SettingsConf.FontDescription.PreviewWindows;
        }
        if (Util.IS_LINUX) {
            return SettingsConf.FontDescription.PreviewLinux;
        }
        if (Util.IS_MAC_OS_X) {
            return SettingsConf.FontDescription.PreviewMacOsX;
        }
        throw new IllegalStateException();
    }

    public static SettingsConf.FontDescription getPreviewFontMono() {
        if (Util.IS_WINDOWS) {
            return SettingsConf.FontDescription.PreviewMonoWindows;
        }
        if (Util.IS_LINUX) {
            return SettingsConf.FontDescription.PreviewMonoLinux;
        }
        if (Util.IS_MAC_OS_X) {
            return SettingsConf.FontDescription.PreviewMonoMacOsX;
        }
        throw new IllegalStateException();
    }

    public static String toString(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        boolean bl = (n & 0x40000) != 0;
        boolean bl2 = (n & 0x20000) != 0;
        boolean bl3 = (n & 0x10000) != 0;
        Object object = "";
        switch (n2) {
            case 0x100000A: {
                object = Msg.f1.get();
                break;
            }
            case 0x100000B: {
                object = Msg.f2.get();
                break;
            }
            case 0x100000C: {
                object = Msg.f3.get();
                break;
            }
            case 0x100000D: {
                object = Msg.f4.get();
                break;
            }
            case 0x100000E: {
                object = Msg.f5.get();
                break;
            }
            case 0x100000F: {
                object = Msg.f6.get();
                break;
            }
            case 0x1000010: {
                object = Msg.f7.get();
                break;
            }
            case 0x1000011: {
                object = Msg.f8.get();
                break;
            }
            case 0x1000012: {
                object = Msg.f9.get();
                break;
            }
            case 0x1000013: {
                object = Msg.f10.get();
                break;
            }
            case 0x1000014: {
                object = Msg.f11.get();
                break;
            }
            case 0x1000015: {
                object = Msg.f12.get();
                break;
            }
            case 0x1000055: {
                object = Msg.pause_key.get();
                break;
            }
            case 16777303: {
                object = Msg.print_screen_key.get();
                break;
            }
            case 8: {
                object = Msg.backspace_key.get();
                break;
            }
            case 13: {
                object = Msg.enter_key.get();
                break;
            }
            case 0x1000009: {
                object = Msg.insert_key.get();
                break;
            }
            case 127: {
                object = Msg.delete_key.get();
                break;
            }
            case 0x1000007: {
                object = Msg.home_key.get();
                break;
            }
            case 0x1000008: {
                object = Msg.end_key.get();
                break;
            }
            case 0x1000005: {
                object = Msg.page_up_key.get();
                break;
            }
            case 0x1000006: {
                object = Msg.page_down_key.get();
                break;
            }
            case 0x1000001: {
                object = Msg.arrow_up.get();
                break;
            }
            case 0x1000002: {
                object = Msg.arrow_down.get();
                break;
            }
            case 0x1000003: {
                object = Msg.arrow_left.get();
                break;
            }
            case 0x1000004: {
                object = Msg.arrow_right.get();
                break;
            }
            default: {
                object = String.valueOf((char)n2).toUpperCase();
            }
        }
        if (bl3) {
            object = Msg.alt_key.get() + " + " + (String)object;
        }
        if (bl2) {
            object = Msg.shift_key.get() + " + " + (String)object;
        }
        if (bl) {
            object = Msg.ctrl_key.get() + " + " + (String)object;
        }
        return object;
    }

    private static void drawLines(GC gC, Point point, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            gC.drawLine(n, n, point.x + n2, n);
        }
        if (bl2) {
            gC.drawLine(n, point.y + n2, point.x + n2, point.y + n2);
        }
        if (bl3) {
            gC.drawLine(n, n, n, point.y + n2);
        }
        if (bl4) {
            gC.drawLine(point.x + n2, n, point.x + n2, point.y + n2);
        }
    }

    public static void setCenteredBounds(Shell shell, int n, int n2) {
        shell.setSize(n, n2);
        Composite composite = shell.getParent();
        Rectangle rectangle = null;
        rectangle = composite == null || !composite.isVisible() ? shell.getMonitor().getBounds() : composite.getBounds();
        int n3 = (rectangle.width - n) / 2;
        int n4 = (rectangle.height - n2) / 2;
        if (composite != null) {
            n3 += rectangle.x;
            n4 += rectangle.y;
        }
        shell.setLocation(n3, n4);
    }

    public static void setCenteredBounds(Shell shell) {
        shell.pack();
        Point point = shell.getSize();
        Composite composite = shell.getParent();
        Rectangle rectangle = null;
        rectangle = composite == null || !composite.isVisible() ? shell.getMonitor().getBounds() : composite.getBounds();
        int n = (rectangle.width - point.x) / 2;
        int n2 = (rectangle.height - point.y) / 2;
        if (composite != null) {
            n += rectangle.x;
            n2 += rectangle.y;
        }
        shell.setLocation(n, n2);
    }

    public static void setCenteredBounds(Shell shell, Control control) {
        shell.pack();
        Point point = shell.getSize();
        Composite composite = control.getParent();
        Rectangle rectangle = control.getBounds();
        rectangle = control.getDisplay().map((Control)composite, null, rectangle);
        int n = rectangle.x + (rectangle.width - point.x) / 2;
        int n2 = rectangle.y + (rectangle.height - point.y) / 2;
        shell.setLocation(n, n2);
    }

    public static void setCenteredMinBounds(Shell shell, int n, int n2) {
        Point point = shell.computeSize(-1, -1);
        int n3 = Math.max(point.x, n);
        int n4 = Math.max(point.y, n2);
        UtilGui.setCenteredBounds(shell, n3, n4);
    }

    public static Button[] maybeSwapButtons(Button button, Button button2) {
        boolean bl = button.getDisplay().getDismissalAlignment() == 16384;
        return new Button[]{bl ? button : button2, bl ? button2 : button};
    }

    public static boolean contains(int n, int n2) {
        return (n & n2) == n2;
    }

    public static FillLayout createFillLayout(int n) {
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = fillLayout.marginHeight = n;
        return fillLayout;
    }

    public static GridLayout createGridLayout(int n, boolean bl, int n2, int n3) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = gridLayout.marginHeight = n2;
        gridLayout.horizontalSpacing = gridLayout.verticalSpacing = n3;
        return gridLayout;
    }

    public static FormLayout createFormLayout(int n) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = formLayout.marginHeight = n;
        return formLayout;
    }

    public static Text createLabeledGridText(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return text;
    }

    public static Text createUnlabeledGridText(Composite composite) {
        Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return text;
    }

    public static StyledText createLabeledGridStyledText(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        StyledText styledText = new StyledText(composite, 2052);
        styledText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return styledText;
    }

    public static Button createCheckButton(Composite composite, String string) {
        Button button = new Button(composite, 32);
        button.setText(string);
        return button;
    }

    public static Button createPushButton(Composite composite, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setText(string);
        button.addSelectionListener(selectionListener);
        return button;
    }

    public static Button createPushButton(Composite composite, Image image, String string, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setImage(image);
        if (string != null) {
            button.setToolTipText(string);
        }
        button.addSelectionListener(selectionListener);
        return button;
    }

    public static void assertSwtThread() {
        if (Display.getCurrent() == null) {
            throw new IllegalStateException();
        }
    }

    public static boolean runSwtSafe(Widget widget, Runnable runnable) {
        if (Display.getCurrent() != null) {
            boolean bl;
            boolean bl2 = bl = widget != null && !widget.isDisposed();
            if (bl) {
                runnable.run();
            }
            return bl;
        }
        return UtilGui.runSyncExec(widget, runnable);
    }

    public static boolean runSwtSafe(Display display, Runnable runnable) {
        if (Display.getCurrent() != null) {
            boolean bl;
            boolean bl2 = bl = display != null && !display.isDisposed();
            if (bl) {
                runnable.run();
            }
            return bl;
        }
        return UtilGui.runSyncExec(display, runnable);
    }

    public static boolean runSyncExec(final Widget widget, final Runnable runnable) {
        if (widget == null || widget.isDisposed()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{false};
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean bl = blArray[0] = !widget.isDisposed();
                if (blArray[0]) {
                    runnable.run();
                }
            }
        });
        return blArray[0];
    }

    public static boolean runSyncExec(final Display display, final Runnable runnable) {
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{false};
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                boolean bl = blArray[0] = !display.isDisposed();
                if (blArray[0]) {
                    runnable.run();
                }
            }
        });
        return blArray[0];
    }

    public static void runAsyncExec(final Widget widget, final Runnable runnable) {
        if (widget == null || widget.isDisposed()) {
            return;
        }
        widget.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!widget.isDisposed()) {
                    runnable.run();
                }
            }
        });
    }

    public static void runAsyncExec(final Display display, final Runnable runnable) {
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    runnable.run();
                }
            }
        });
    }

    public static boolean launch(String string) {
        Util.checkNotNull(string);
        if (Util.IS_LINUX_KDE) {
            return UtilGui.launchXdgOpen(string);
        }
        if (Program.launch((String)string)) {
            return true;
        }
        if (!Util.IS_LINUX) {
            return false;
        }
        return UtilGui.launchXdgOpen(string);
    }

    public static boolean launch(File file) {
        Util.checkNotNull(file);
        return UtilGui.launch(Util.getSystemAbsPath(file));
    }

    private static boolean launchXdgOpen(String string) {
        try {
            String[] stringArray = new String[]{"xdg-open", string};
            Process process = Runtime.getRuntime().exec(stringArray);
            int n = process.waitFor();
            return n == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void selectAllOnFocus(Control control) {
        Util.checkThat(control instanceof Combo || control instanceof Text || control instanceof StyledText);
        class SelectAllOnFocus
        extends MouseAdapter
        implements FocusListener {
            private boolean focusGained = false;
            final /* synthetic */ Control val$text;

            SelectAllOnFocus(Control control) {
                this.val$text = control;
            }

            public void focusGained(FocusEvent focusEvent) {
                this.focusGained = true;
            }

            public void focusLost(FocusEvent focusEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (!this.focusGained) {
                    return;
                }
                if (this.val$text instanceof Combo) {
                    UtilGui.selectAll((Combo)this.val$text);
                } else if (this.val$text instanceof Text) {
                    ((Text)this.val$text).selectAll();
                } else if (this.val$text instanceof StyledText) {
                    ((StyledText)this.val$text).selectAll();
                }
                this.focusGained = false;
            }
        }
        SelectAllOnFocus selectAllOnFocus = new SelectAllOnFocus(control);
        control.addFocusListener((FocusListener)selectAllOnFocus);
        control.addMouseListener((MouseListener)selectAllOnFocus);
    }

    public static void registerSelectAllKey(final StyledText styledText) {
        if (selectAllKeyListener == null) {
            selectAllKeyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.stateMask == SWT.MOD1 || keyEvent.keyCode == 97) {
                        styledText.selectAll();
                    }
                }
            };
        }
        styledText.addKeyListener(selectAllKeyListener);
    }

    public static void selectAll(Combo combo) {
        int n = combo.getText().length();
        combo.setSelection(new Point(0, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> getFilesFromClipboard() {
        UtilGui.assertSwtThread();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        try {
            TransferData[] transferDataArray;
            for (TransferData transferData : transferDataArray = clipboard.getAvailableTypes()) {
                Object object;
                if (!FileTransfer.getInstance().isSupportedType(transferData) || (object = clipboard.getContents((Transfer)FileTransfer.getInstance())) == null || !(object instanceof String[])) continue;
                String[] stringArray = (String[])object;
                ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
                for (String string : stringArray) {
                    arrayList.add(new File(string));
                }
                ArrayList<File> arrayList2 = arrayList;
                return arrayList2;
            }
            TransferData[] transferDataArray2 = null;
            return transferDataArray2;
        }
        finally {
            clipboard.dispose();
        }
    }

    public static void setClipboard(String string) {
        Util.checkNotNull(string);
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(new Object[]{string}, transferArray);
        clipboard.dispose();
    }

    public static void setClipboard(Collection<File> collection) {
        Util.checkNotNull(collection);
        if (collection.isEmpty()) {
            return;
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (File file : collection) {
            if (n != 0) {
                stringBuilder.append("\n");
            }
            String string = Util.getSystemAbsPath(file);
            stringBuilder.append(string);
            stringArray[n] = string;
            ++n;
        }
        clipboard.setContents(new Object[]{stringBuilder.toString(), stringArray}, transferArray);
        clipboard.dispose();
    }

    public static void addMouseHighlighter(final Control control) {
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent mouseEvent) {
                control.setBackground(Col.WIDGET_HIGHLIGHT_SHADOW.get());
            }

            public void mouseExit(MouseEvent mouseEvent) {
                control.setBackground(null);
            }
        });
    }

    public static boolean isEnterKey(int n) {
        return n == 13 || n == 0x1000050;
    }

    public static boolean isAlphaNumeric(int n) {
        return n >= 97 && n <= 122 || n >= 48 && n <= 57;
    }

    public static void disposeWith(Widget widget, final Resource ... resourceArray) {
        Util.checkNotNull(widget, resourceArray);
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                for (Resource resource : resourceArray) {
                    if (resource == null) continue;
                    resource.dispose();
                }
            }
        });
    }

    public static class PaintBorder {
        public PaintBorder(final Control control) {
            control.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    Point point = control.getSize();
                    boolean bl = this.isBorderVisible(128);
                    boolean bl2 = this.isBorderVisible(1024);
                    boolean bl3 = this.isBorderVisible(16384);
                    boolean bl4 = this.isBorderVisible(131072);
                    paintEvent.gc.setForeground(Col.WIDGET_NORMAL_SHADOW.get());
                    UtilGui.drawLines(paintEvent.gc, point, 0, -1, bl, bl2, bl3, bl4);
                    paintEvent.gc.setForeground(Col.WIDGET_LIGHT_SHADOW.get());
                    UtilGui.drawLines(paintEvent.gc, point, 1, -2, bl, bl2, bl3, bl4);
                }
            });
        }

        protected boolean isBorderVisible(int n) {
            return true;
        }
    }
}

