/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.docfetcher.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class UtilTest {
    @Test
    public void testSplitPath() {
        String[][] stringArrayArray;
        for (String[] stringArray : stringArrayArray = new String[][]{{"path/to/file", "path", "to", "file"}, {"/path/to/file", "", "path", "to", "file"}, {"path/to/file/", "path", "to", "file"}, {"/path/to/file/", "", "path", "to", "file"}, {"/", ""}, {"//", "", ""}, {"", ""}}) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            List<String> list = Util.splitPath(stringArray[0]);
            if (arrayList.size() == 0 || list.size() == 0) continue;
            Assert.assertEquals(arrayList, list);
        }
    }

    @Test
    public void testJoinPath() {
        String[][] stringArrayArray;
        for (String[] stringArray : stringArrayArray = new String[][]{{"", "", ""}, {"path", "path", ""}, {"path", "", "path"}, {"path/to/file", "path", "to", "file"}, {"path/to/file", "path/", "to", "file/"}}) {
            String string = stringArray[0];
            String[] stringArray2 = Arrays.copyOfRange(stringArray, 3, stringArray.length);
            String string2 = Util.joinPath(stringArray[1], stringArray[2], stringArray2);
            Assert.assertEquals((Object)string, (Object)string2);
        }
    }

    @Test
    public void testCreateTempFile() throws IOException {
        File file = Util.createTempFile("1", null);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.getName().startsWith("1__"));
    }

    @Test
    public void testIsDriveLetter() {
        class Sample {
            private final String input;
            private final boolean expectedOutput;

            private Sample(String string, boolean bl) {
                this.input = string;
                this.expectedOutput = bl;
            }
        }
        Sample[] sampleArray;
        for (Sample sample : sampleArray = new Sample[]{new Sample("C:", true), new Sample("G:\\", true), new Sample("x:\\\\", true), new Sample("f:\\Foo\\", false), new Sample("c:\\\\Foo", false), new Sample("c://", true), new Sample("c://Foo", false), new Sample("c:\\/", true)}) {
            boolean bl = Util.isWindowsDevice(sample.input);
            Assert.assertEquals((Object)sample.expectedOutput, (Object)bl);
        }
    }

    @Test
    public void testGetCanonicalFile() {
        if (Util.IS_WINDOWS) {
            File file = Util.getCanonicalFile("C:\\//\\");
            Assert.assertEquals((Object)"C:\\", (Object)file.getPath());
        }
    }
}

