/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.collect;

import com.google.common.collect.ForwardingCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sourceforge.docfetcher.util.Util;

public final class BoundedList<T>
extends ForwardingCollection<T> {
    private final int capacity;
    private final boolean removeEldest;
    private int virtualSize = 0;
    private LinkedList<T> list = new LinkedList();

    public BoundedList(int n) {
        this(n, true);
    }

    public BoundedList(int n, boolean bl) {
        Util.checkThat(n >= 0);
        this.capacity = n;
        this.removeEldest = bl;
    }

    protected Collection<T> delegate() {
        return this.list;
    }

    public boolean add(T t) {
        boolean bl;
        Util.checkNotNull(t);
        boolean bl2 = bl = this.capacity > 0;
        if (this.removeEldest) {
            this.list.add(t);
            if (this.list.size() > this.capacity) {
                this.list.removeFirst();
            }
        } else if (this.list.size() < this.capacity) {
            this.list.add(t);
        } else {
            bl = false;
        }
        ++this.virtualSize;
        return bl;
    }

    public boolean addAll(Collection<? extends T> collection) {
        boolean bl;
        Util.checkNotNull(collection);
        if (collection.isEmpty()) {
            return false;
        }
        boolean bl2 = bl = this.capacity > 0;
        if (this.removeEldest) {
            this.list.addAll(collection);
            while (this.list.size() > this.capacity) {
                this.list.removeFirst();
            }
        } else {
            int n = this.capacity - this.list.size();
            assert (n >= 0);
            if (n > 0) {
                Iterator<T> iterator = collection.iterator();
                for (int i = 0; i < n && iterator.hasNext(); ++i) {
                    this.list.add(iterator.next());
                }
            } else {
                bl = false;
            }
        }
        this.virtualSize += collection.size();
        return bl;
    }

    public T getLast() {
        return this.list.getLast();
    }

    public int getVirtualSize() {
        return this.virtualSize;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Iterator<T> iterator() {
        final Iterator iterator = this.list.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                --BoundedList.this.virtualSize;
                assert (BoundedList.this.virtualSize >= 0);
            }
        };
    }

    public boolean remove(Object object) {
        boolean bl = this.list.remove(object);
        if (bl) {
            --this.virtualSize;
        }
        assert (this.virtualSize >= 0);
        return bl;
    }

    public boolean removeAll(Collection<?> collection) {
        Iterator iterator = this.list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!collection.contains(e)) continue;
            iterator.remove();
            --this.virtualSize;
            bl = true;
        }
        assert (this.virtualSize >= 0);
        return bl;
    }

    public boolean retainAll(Collection<?> collection) {
        Iterator iterator = this.list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (collection.contains(e)) continue;
            iterator.remove();
            --this.virtualSize;
            bl = true;
        }
        assert (this.virtualSize >= 0);
        return bl;
    }

    public void clear() {
        this.list.clear();
        this.virtualSize = 0;
    }
}

