/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.collect;

import com.google.common.collect.Iterators;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class LazyList<T>
extends AbstractList<T> {
    private List<T> list;

    @Override
    public T get(int n) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.get(n);
    }

    @Override
    public int size() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public T set(int n, T t) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.set(n, t);
    }

    @Override
    public void add(int n, T t) {
        this.getList().add(n, t);
    }

    @Override
    public T remove(int n) {
        if (this.list == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.list.remove(n);
    }

    private List<T> getList() {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        }
        return this.list;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.list == null) {
            return Iterators.emptyIterator();
        }
        return this.list.iterator();
    }
}

