/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.docfetcher.util.Util;

public final class ListMap<K, V>
implements Iterable<Entry<K, V>> {
    private final List<Entry<K, V>> list;

    public static <K, V> ListMap<K, V> create() {
        return new ListMap<K, V>();
    }

    public static <K, V> ListMap<K, V> create(int n) {
        return new ListMap<K, V>(n);
    }

    private ListMap() {
        this.list = new ArrayList<Entry<K, V>>();
    }

    private ListMap(int n) {
        this.list = new ArrayList<Entry<K, V>>(n);
    }

    public ListMap<K, V> add(K k, V v) {
        Util.checkNotNull(k, v);
        this.list.add(new Entry<K, V>(k, v));
        return this;
    }

    public V getValue(K k) {
        Util.checkNotNull(k);
        for (Entry<K, V> entry : this.list) {
            if (!entry.key.equals(k)) continue;
            return entry.value;
        }
        return null;
    }

    public K getKey(V v) {
        Util.checkNotNull(v);
        for (Entry<K, V> entry : this.list) {
            if (!entry.value.equals(v)) continue;
            return entry.key;
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean containsKey(K k) {
        return this.getValue(k) != null;
    }

    public boolean containsValue(V v) {
        return this.getKey(v) != null;
    }

    public boolean removeKey(K k) {
        Util.checkNotNull(k);
        Iterator<Entry<K, V>> iterator = this.list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Entry<K, V> entry = iterator.next();
            if (!entry.key.equals(k)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeValue(V v) {
        Util.checkNotNull(v);
        Iterator<Entry<K, V>> iterator = this.list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Entry<K, V> entry = iterator.next();
            if (!entry.value.equals(v)) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void replaceKey(K k, V v) {
        Util.checkNotNull(k, v);
        boolean bl = false;
        for (Entry<K, V> entry : this.list) {
            if (!entry.value.equals(v)) continue;
            entry.key = k;
            bl = true;
        }
        if (!bl) {
            this.list.add(new Entry<K, V>(k, v));
        }
    }

    public void replaceValue(K k, V v) {
        Util.checkNotNull(k, v);
        boolean bl = false;
        for (Entry<K, V> entry : this.list) {
            if (!entry.key.equals(k)) continue;
            entry.value = v;
            bl = true;
        }
        if (!bl) {
            this.list.add(new Entry<K, V>(k, v));
        }
    }

    public Entry<K, V> getEntry(int n) {
        return this.list.get(n);
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return this.list.iterator();
    }

    public List<K> getKeys() {
        ArrayList arrayList = new ArrayList(this.list.size());
        for (Entry<K, V> entry : this.list) {
            arrayList.add(entry.key);
        }
        return arrayList;
    }

    public List<V> getValues() {
        ArrayList arrayList = new ArrayList(this.list.size());
        for (Entry<K, V> entry : this.list) {
            arrayList.add(entry.value);
        }
        return arrayList;
    }

    public void sort(Comparator<Entry<K, V>> comparator) {
        Collections.sort(this.list, comparator);
    }

    public static final class Entry<K, V> {
        private K key;
        private V value;

        private Entry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

