/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.collect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.docfetcher.util.Util;

public final class MemoryList<E>
implements Collection<E> {
    private final LinkedList<E> list = new LinkedList();
    private final int capacity;

    public MemoryList(int n) {
        Util.checkThat(n >= 0);
        this.capacity = n;
    }

    @Override
    public boolean add(E e) {
        if (!this.list.isEmpty() && this.list.getFirst().equals(e)) {
            return false;
        }
        this.list.remove(e);
        this.list.addFirst(e);
        if (this.list.size() > this.capacity) {
            this.list.removeLast();
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        List<Object> list = collection instanceof List ? (List<Object>)collection : new ArrayList<E>(collection);
        boolean bl = false;
        for (Object e : Lists.reverse((List)list)) {
            bl |= this.add(e);
        }
        return bl;
    }

    public E getMostRecent() {
        return this.list.getFirst();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

