/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.concurrent;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sourceforge.docfetcher.util.Util;

public abstract class MergingBlockingQueue<T> {
    private T item;
    private final Lock lock = new ReentrantLock(true);
    private final Condition notNull = this.lock.newCondition();

    public void put(T t) {
        Util.checkNotNull(t);
        this.lock.lock();
        try {
            this.item = this.item == null ? t : this.merge(this.item, t);
            this.notNull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.item == null) {
                this.notNull.await();
            }
            T t = this.item;
            this.item = null;
            T t2 = t;
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract T merge(T var1, T var2);
}

