/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class BrowserPopupBlocker {
    public static void initialize(final Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent windowEvent) {
                Shell shell = new Shell(display);
                shell.setText("New Window");
                shell.setLayout((Layout)new FillLayout());
                Browser browser = new Browser((Composite)shell, 0);
                BrowserPopupBlocker.initialize(display, browser);
                windowEvent.browser = browser;
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent windowEvent) {
                Browser browser = (Browser)windowEvent.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent windowEvent) {
                boolean bl;
                Browser browser = (Browser)windowEvent.widget;
                final Shell shell = browser.getShell();
                boolean bl2 = bl = SWT.getPlatform().equals("cocoa") || SWT.getPlatform().equals("carbon");
                if (!(windowEvent.addressBar || windowEvent.statusBar || windowEvent.toolBar || windowEvent.menuBar && !bl)) {
                    UtilGui.runAsyncExec(windowEvent.display, new Runnable(){

                        @Override
                        public void run() {
                            shell.close();
                        }
                    });
                    return;
                }
                if (windowEvent.location != null) {
                    shell.setLocation(windowEvent.location);
                }
                if (windowEvent.size != null) {
                    Point point = windowEvent.size;
                    shell.setSize(shell.computeSize(point.x, point.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent windowEvent) {
                Browser browser = (Browser)windowEvent.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }
}

