/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public final class ContextMenuManager {
    private final Menu menu;

    public static void main(String[] stringArray) {
        final Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)UtilGui.createFillLayout(5));
        UtilGui.setCenteredBounds(shell, 400, 300);
        Label label = new Label((Composite)shell, 0x1000000);
        label.setText("Right-click on the area below to open the menu.\n" + String.format("(It will automatically close after %d ms.)", 2000));
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)label);
        class MyMenuAction
        extends MenuAction {
            private final String label;
            private final boolean enabled;

            public MyMenuAction(String string, boolean bl) {
                super(string);
                this.label = string;
                this.enabled = bl;
            }

            @Override
            public boolean isEnabled() {
                return this.enabled;
            }

            @Override
            public void run() {
                Util.println(this.label + " clicked");
            }
        }
        contextMenuManager.add(new MyMenuAction("item 1", true));
        contextMenuManager.add(new MyMenuAction("item 2", false));
        contextMenuManager.addSeparator();
        Menu menu = contextMenuManager.addSubmenu(new MenuAction("submenu"));
        contextMenuManager.add(menu, new MyMenuAction("sub-item 1", true));
        contextMenuManager.add(menu, new MyMenuAction("sub-item 2", false));
        contextMenuManager.addSeparator(menu);
        final Menu menu2 = label.getMenu();
        menu2.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                display.timerExec(2000, new Runnable(){

                    @Override
                    public void run() {
                        menu2.setVisible(false);
                    }
                });
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public ContextMenuManager(Control control) {
        Util.checkNotNull(control);
        this.menu = new Menu(control);
        control.setMenu(this.menu);
        control.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                ContextMenuManager.updateEnabledStates(ContextMenuManager.this.menu);
            }
        });
    }

    private static void updateEnabledStates(Menu menu) {
        for (MenuItem menuItem : menu.getItems()) {
            MenuAction menuAction = (MenuAction)menuItem.getData();
            if (menuAction == null) {
                assert (UtilGui.contains(menuItem.getStyle(), 2));
                continue;
            }
            menuItem.setEnabled(menuAction.isEnabled());
            if (!UtilGui.contains(menuItem.getStyle(), 64)) continue;
            ContextMenuManager.updateEnabledStates(menuItem.getMenu());
        }
    }

    public void add(MenuAction menuAction) {
        this.add(this.menu, menuAction);
    }

    public void add(Menu menu, final MenuAction menuAction) {
        Util.checkNotNull(menuAction);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setImage(menuAction.getImage());
        menuItem.setText(menuAction.getLabel());
        menuItem.setEnabled(menuAction.isEnabled());
        menuItem.setData((Object)menuAction);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (menuAction.isEnabled()) {
                    menuAction.run();
                }
            }
        });
        if (menuAction.isDefaultItem()) {
            menu.setDefaultItem(menuItem);
        }
    }

    public void addSeparator() {
        new MenuItem(this.menu, 2);
    }

    public void addSeparatorIfNonEmpty() {
        int n = this.menu.getItemCount();
        if (n == 0) {
            return;
        }
        MenuItem menuItem = this.menu.getItem(n - 1);
        if ((menuItem.getStyle() & 2) == 0) {
            new MenuItem(this.menu, 2);
        }
    }

    public void addSeparator(Menu menu) {
        new MenuItem(menu, 2);
    }

    public Menu addSubmenu(MenuAction menuAction) {
        Util.checkNotNull(menuAction);
        MenuItem menuItem = new MenuItem(this.menu, 64);
        menuItem.setImage(menuAction.getImage());
        menuItem.setText(menuAction.getLabel());
        menuItem.setEnabled(menuAction.isEnabled());
        menuItem.setData((Object)menuAction);
        Menu menu = new Menu(menuItem);
        menuItem.setMenu(menu);
        return menu;
    }
}

