/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class DropDownMenuManager {
    private final List<MenuAction> menuItems = new ArrayList<MenuAction>();
    private final ToolItem toolItem;
    private final Point location;
    private final Control parent;

    public DropDownMenuManager(ToolItem toolItem, Control control) {
        Util.checkNotNull(toolItem, control);
        this.toolItem = toolItem;
        this.parent = control;
        this.location = null;
    }

    public DropDownMenuManager(Point point, Control control) {
        Util.checkNotNull(point, control);
        this.location = point;
        this.parent = control;
        this.toolItem = null;
    }

    public Menu show() {
        final Menu menu = new Menu(this.parent);
        if (this.location == null) {
            Object object = this.toolItem.getBounds();
            ((Rectangle)object).y += ((Rectangle)object).height;
            object = this.parent.getDisplay().map((Control)this.toolItem.getParent(), null, (Rectangle)object);
            menu.setLocation(((Rectangle)object).x, ((Rectangle)object).y);
        } else {
            menu.setLocation(this.location.x, this.location.y);
        }
        for (final MenuAction menuAction : this.menuItems) {
            if (menuAction == null) {
                new MenuItem(menu, 2);
                continue;
            }
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setImage(menuAction.getImage());
            menuItem.setText(menuAction.getLabel());
            menuItem.setEnabled(menuAction.isEnabled());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    menuAction.run();
                }
            });
        }
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent menuEvent) {
                UtilGui.runAsyncExec((Widget)DropDownMenuManager.this.parent, new Runnable(){

                    @Override
                    public void run() {
                        menu.dispose();
                    }
                });
            }
        });
        menu.setVisible(true);
        return menu;
    }

    public void add(MenuAction menuAction) {
        Util.checkNotNull(menuAction);
        this.menuItems.add(menuAction);
    }

    public void addSeparator() {
        this.menuItems.add(null);
    }
}

