/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.sourceforge.docfetcher.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class FileIconCache {
    private static final int maxSize = 16;
    private final Map<String, Image> fileIconMap = Maps.newHashMap();
    private final Widget disposeWidget;

    public FileIconCache(Widget widget) {
        this.disposeWidget = widget;
        widget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                for (Image image : FileIconCache.this.fileIconMap.values()) {
                    image.dispose();
                }
                FileIconCache.this.fileIconMap.clear();
            }
        });
    }

    public Image getIcon(File file, Image image) {
        return this.getIcon(file.getName(), image);
    }

    public Image getIcon(String string, Image image) {
        String string2 = Util.getExtension(string);
        Image image2 = this.fileIconMap.get(string2);
        if (image2 != null) {
            return image2;
        }
        Program program = Program.findProgram((String)string2);
        if (program == null) {
            return image;
        }
        ImageData imageData = program.getImageData();
        if (imageData == null) {
            return image;
        }
        image2 = imageData.width > 16 || imageData.height > 16 ? FileIconCache.scaleTo(imageData, this.disposeWidget.getDisplay(), 16, 16) : new Image((Device)this.disposeWidget.getDisplay(), imageData);
        this.fileIconMap.put(string2, image2);
        return image2;
    }

    private static Image scaleTo(ImageData imageData, Display display, int n, int n2) {
        Image image = new Image((Device)display, imageData);
        Image image2 = new Image((Device)display, n, n2);
        GC gC = new GC((Drawable)image2);
        gC.setAntialias(1);
        gC.setInterpolation(2);
        gC.drawImage(image, 0, 0, imageData.width, imageData.height, 0, 0, n, n2);
        gC.dispose();
        image.dispose();
        return image2;
    }
}

