/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.LazyList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class LazyImageCache {
    private Map<String, Image> imageMap = Maps.newHashMap();
    private final Display display;
    private final File imageDir;

    public LazyImageCache(Display display, String string) {
        Util.checkNotNull(display, string);
        this.imageDir = new File(string);
        Util.checkThat(this.imageDir.isDirectory());
        this.display = display;
        display.disposeExec(new Runnable(){

            @Override
            public void run() {
                for (Image image : LazyImageCache.this.imageMap.values()) {
                    image.dispose();
                }
                LazyImageCache.this.imageMap.clear();
                LazyImageCache.this.imageMap = null;
            }
        });
    }

    public Image getImage(String string) {
        if (this.imageMap == null) {
            return null;
        }
        Image image = this.imageMap.get(string);
        if (image == null) {
            try {
                image = new Image((Device)this.display, new File(this.imageDir, string).getPath());
                this.imageMap.put(string, image);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return image;
    }

    public <T extends Enum<T>> void reportMissingFiles(Shell shell, Class<T> clazz, String string) {
        LazyList lazyList = new LazyList();
        for (Enum object : (Enum[])clazz.getEnumConstants()) {
            File file = new File(this.imageDir, object.getFilename());
            if (file.isFile()) continue;
            lazyList.add(file);
        }
        if (lazyList.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        int n = 0;
        for (File file : lazyList) {
            if (n >= 5) {
                arrayList.add("...");
                break;
            }
            arrayList.add(Util.getSystemAbsPath(file));
            ++n;
        }
        AppUtil.showError(string + "\n" + Joiner.on((String)"\n").join((Iterable)arrayList), true, false);
    }

    public static interface FilenameProvider {
        public String getFilename();
    }
}

