/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui;

import java.util.LinkedList;
import java.util.regex.Pattern;
import net.sourceforge.docfetcher.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public final class UndoRedoProvider {
    private static Pattern leadingSpaces = Pattern.compile("[\\s&&[^\\n\\r]]*\\S+");
    private static Pattern trailingSpaces = Pattern.compile("\\S+[\\s&&[^\\n\\r]]*");

    private UndoRedoProvider() {
    }

    public static void applyTo(final StyledText styledText, final int n) {
        Util.checkNotNull(styledText);
        Util.checkThat(n >= 0);
        final LinkedList linkedList = new LinkedList();
        final LinkedList linkedList2 = new LinkedList();
        final ExtendedModifyListener extendedModifyListener = new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent extendedModifyEvent) {
                linkedList.add(new Edit(extendedModifyEvent.start, extendedModifyEvent.length, extendedModifyEvent.replacedText));
                this.mergeLastUndos();
                while (linkedList.size() > n) {
                    linkedList.removeFirst();
                }
                linkedList2.clear();
            }

            private void mergeLastUndos() {
                if (linkedList.size() <= 1) {
                    return;
                }
                Edit edit = (Edit)linkedList.get(linkedList.size() - 2);
                Edit edit2 = (Edit)linkedList.getLast();
                if (edit.start + edit.length == edit2.start && edit.text.equals("") && edit2.text.equals("")) {
                    String string = styledText.getTextRange(edit.start, edit.length + edit2.length);
                    if (trailingSpaces.matcher(string).matches()) {
                        int n2 = edit.length + edit2.length;
                        this.doMergeLastUndos(new Edit(edit.start, n2, ""));
                    }
                } else if (edit.length == 0 && edit2.length == 0) {
                    String string;
                    if (edit2.start + edit2.text.length() == edit.start) {
                        String string2 = edit2.text + edit.text;
                        if (leadingSpaces.matcher(string2).matches()) {
                            this.doMergeLastUndos(new Edit(edit2.start, 0, string2));
                        }
                    } else if (edit.start == edit2.start && trailingSpaces.matcher(string = edit.text + edit2.text).matches()) {
                        this.doMergeLastUndos(new Edit(edit2.start, 0, string));
                    }
                }
            }

            private void doMergeLastUndos(Edit edit) {
                linkedList.removeLast();
                linkedList.removeLast();
                linkedList.add(edit);
            }
        };
        styledText.addExtendedModifyListener(extendedModifyListener);
        styledText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode != 122) {
                    return;
                }
                if ((keyEvent.stateMask & SWT.MOD1) == 0) {
                    return;
                }
                if ((keyEvent.stateMask & 0x20000) == 0) {
                    this.applyEdit(linkedList, linkedList2);
                } else {
                    this.applyEdit(linkedList2, linkedList);
                }
            }

            private void applyEdit(LinkedList<Edit> linkedList3, LinkedList<Edit> linkedList22) {
                if (linkedList3.isEmpty()) {
                    return;
                }
                Edit edit = linkedList3.removeLast();
                String string = styledText.getTextRange(edit.start, edit.length);
                styledText.removeExtendedModifyListener(extendedModifyListener);
                styledText.replaceTextRange(edit.start, edit.length, edit.text);
                styledText.addExtendedModifyListener(extendedModifyListener);
                linkedList22.add(new Edit(edit.start, edit.text.length(), string));
                styledText.setCaretOffset(edit.start + edit.text.length());
            }
        });
    }

    private static class Edit {
        private int start;
        private int length;
        private String text;

        public Edit(int n, int n2, String string) {
            this.start = n;
            this.length = n2;
            this.text = string;
        }
    }
}

