/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.dialog;

import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class ListConfirmDialog {
    public final Event<String> evtLinkClicked = new Event();
    private final Shell shell;
    private final Link textControl;
    private final Table table;
    private final Button okBt;
    private final Button cancelBt;
    private boolean answerOK = false;

    public static void main(String[] stringArray) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Image image = display.getSystemImage(8);
        final Image image2 = new Image((Device)display, image.getImageData().scaledTo(16, 16));
        UtilGui.createPushButton((Composite)shell, "Open Dialog", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListConfirmDialog listConfirmDialog = new ListConfirmDialog(shell, 2);
                listConfirmDialog.setTitle("Title");
                listConfirmDialog.setText("This is a message containing a <a href=\"test\">hyperlink</a>.");
                for (int i = 0; i < 10; ++i) {
                    listConfirmDialog.addItem(image2, "Item " + i);
                }
                listConfirmDialog.evtLinkClicked.add(new Event.Listener<String>(){

                    @Override
                    public void update(String string) {
                        Util.println("Link clicked: " + string);
                    }
                });
                listConfirmDialog.open();
            }
        });
        UtilGui.setCenteredBounds(shell, 200, 100);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        image2.dispose();
    }

    public ListConfirmDialog(Shell shell, int n) {
        this.shell = new Shell(shell, 34928);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayout((Layout)UtilGui.createGridLayout(2, false, 0, 5));
        Label label = new Label(composite, 0);
        label.setImage(this.shell.getDisplay().getSystemImage(n));
        label.setLayoutData((Object)new GridData(4, 128, false, true));
        this.textControl = new Link(composite, 0);
        this.textControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table((Composite)this.shell, 2048);
        this.okBt = UtilGui.createPushButton((Composite)this.shell, AppUtil.Messages.ok.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListConfirmDialog.this.answerOK = true;
                ListConfirmDialog.this.shell.close();
            }
        });
        this.cancelBt = UtilGui.createPushButton((Composite)this.shell, AppUtil.Messages.cancel.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListConfirmDialog.this.shell.close();
            }
        });
        this.textControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListConfirmDialog.this.evtLinkClicked.fire(selectionEvent.text);
            }
        });
        Button[] buttonArray = UtilGui.maybeSwapButtons(this.okBt, this.cancelBt);
        this.shell.setLayout((Layout)UtilGui.createFormLayout(5));
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.top().left().right().applyTo((Control)composite);
        formDataFactory.reset().minWidth(75).bottom().right().applyTo((Control)buttonArray[1]);
        formDataFactory.right((Control)buttonArray[1]).applyTo((Control)buttonArray[0]);
        formDataFactory.reset().left().right().top((Control)composite, 10).bottom((Control)buttonArray[1], -10).applyTo((Control)this.table);
    }

    public void setTitle(String string) {
        this.shell.setText(string);
    }

    public void setText(String string) {
        this.textControl.setText(string);
    }

    public void addItem(Image image, String string) {
        TableItem tableItem = new TableItem(this.table, 0);
        if (image != null) {
            tableItem.setImage(image);
        }
        tableItem.setText(string);
    }

    public void setButtonLabels(String string, String string2) {
        this.okBt.setText(string);
        this.cancelBt.setText(string2);
    }

    public boolean open() {
        UtilGui.setCenteredBounds(this.shell, 350, 350);
        this.shell.open();
        this.table.setFocus();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.answerOK;
    }
}

