/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.dialog;

import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class MultipleChoiceDialog<A> {
    private final Shell shell;
    private final Label icon;
    private final Link label;
    private final GridLayout gridLayout;
    private final GridData gridData;
    private Button firstButton;
    private A answer;

    public static void main(String[] stringArray) {
        Display display = new Display();
        final Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        UtilGui.setCenteredBounds(shell, 150, 75);
        Button button = new Button((Composite)shell, 8);
        button.setText("Open Dialog");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MultipleChoiceDialog<String> multipleChoiceDialog = new MultipleChoiceDialog<String>(shell);
                multipleChoiceDialog.setTitle("Choose Wisely");
                multipleChoiceDialog.setImage(4);
                multipleChoiceDialog.setText("Which way?");
                multipleChoiceDialog.addButton("Door 1", "Door 1 chosen.");
                multipleChoiceDialog.addButton("Door 2", "Door 2 chosen.");
                multipleChoiceDialog.addButton("Door 3", "Door 3 chosen.");
                multipleChoiceDialog.addButton("Door 4", "Door 4 chosen.");
                Object a = multipleChoiceDialog.open();
                Util.println(a);
            }
        });
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public MultipleChoiceDialog(Shell shell) {
        Util.checkNotNull(shell);
        this.shell = new Shell(shell, 34912);
        Composite composite = new Composite((Composite)this.shell, 0);
        this.icon = new Label(composite, 0);
        this.icon.setImage(this.shell.getDisplay().getSystemImage(4));
        this.label = new Link(composite, 0);
        this.label.setBackground(this.icon.getBackground());
        this.label.setForeground(this.icon.getForeground());
        this.gridLayout = UtilGui.createGridLayout(0, true, 10, 10);
        this.shell.setLayout((Layout)this.gridLayout);
        this.gridData = new GridData(4, 4, true, true, 0, 1);
        composite.setLayoutData((Object)this.gridData);
        composite.setLayout((Layout)UtilGui.createGridLayout(2, false, 10, 15));
        this.icon.setLayoutData((Object)new GridData(4, 4, false, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 250;
        this.label.setLayoutData((Object)gridData);
        this.label.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UtilGui.launch(selectionEvent.text);
            }
        });
    }

    public void setTitle(String string) {
        Util.checkNotNull(string);
        this.shell.setText(string);
    }

    public void setImage(Image image) {
        Util.checkNotNull(image);
        this.icon.setImage(image);
    }

    public void setImage(int n) {
        this.icon.setImage(this.shell.getDisplay().getSystemImage(n));
    }

    public void setText(String string) {
        Util.checkNotNull(string);
        this.label.setText(string);
    }

    public A addButton(String string, final A a) {
        Util.checkNotNull(string);
        Button button = new Button((Composite)this.shell, 8);
        button.setText(string);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MultipleChoiceDialog.this.answer = a;
                MultipleChoiceDialog.this.shell.close();
            }
        });
        ++this.gridLayout.numColumns;
        ++this.gridData.horizontalSpan;
        if (this.firstButton == null) {
            this.firstButton = button;
        }
        return a;
    }

    public A open() {
        UtilGui.setCenteredBounds(this.shell);
        this.firstButton.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.answer;
    }
}

