/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.util.gui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class VirtualTableViewer<E> {
    private final Table table;
    private final List<Column<E>> columns = new ArrayList<Column<E>>();
    private List<E> elements;
    private boolean sortingEnabled = false;
    private Column<E> lastSortColumn = null;

    public VirtualTableViewer(Composite composite, int n) {
        this.table = new Table(composite, n | 0x10000000);
        this.table.setHeaderVisible(true);
        this.table.addListener(36, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                if (event.index < 0 || event.index >= VirtualTableViewer.this.elements.size()) {
                    return;
                }
                Util.checkThat(!VirtualTableViewer.this.columns.isEmpty());
                TableItem tableItem = (TableItem)event.item;
                Object e = VirtualTableViewer.this.elements.get(event.index);
                for (int i = 0; i < VirtualTableViewer.this.columns.size(); ++i) {
                    Column column = VirtualTableViewer.this.columns.get(i);
                    tableItem.setText(i, column.getLabel(e));
                    tableItem.setImage(i, column.getImage(e));
                    tableItem.setForeground(i, column.getForeground(e));
                    tableItem.setBackground(i, column.getBackground(e));
                }
                tableItem.setData(e);
            }
        });
    }

    public final Table getControl() {
        return this.table;
    }

    public final void addColumn(final Column<E> column) {
        Util.checkNotNull(column);
        this.columns.add(column);
        final TableColumn tableColumn = new TableColumn(this.table, column.orientation);
        tableColumn.setText(column.label);
        tableColumn.setToolTipText(column.getToolTipText());
        column.evtLabelChanged.add(new Event.Listener<String>(){

            @Override
            public void update(String string) {
                tableColumn.setText(string);
            }
        });
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                VirtualTableViewer.this.sortByColumn(column);
            }
        });
    }

    public final void sortByColumn(final Column<E> column) {
        if (this.elements == null || !this.sortingEnabled) {
            return;
        }
        final int n = this.lastSortColumn != column ? 1 : column.lastSortDirection * -1;
        Collections.sort(this.elements, new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                return column.compare(e, e2) * n;
            }
        });
        this.table.clearAll();
        this.lastSortColumn = column;
        column.lastSortDirection = n;
    }

    public final void sortByColumn(final Column<E> column, boolean bl) {
        if (this.elements == null || !this.sortingEnabled) {
            return;
        }
        final int n = bl ? 1 : -1;
        Collections.sort(this.elements, new Comparator<E>(){

            @Override
            public int compare(E e, E e2) {
                return column.compare(e, e2) * n;
            }
        });
        this.table.clearAll();
        this.lastSortColumn = column;
        column.lastSortDirection = n;
    }

    public final List<Column<E>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public final List<Column<E>> getColumnsVisualOrder() {
        ArrayList<Column<E>> arrayList = new ArrayList<Column<E>>(this.columns.size());
        for (int n : this.table.getColumnOrder()) {
            arrayList.add(this.columns.get(n));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public final void setRoot(Object object) {
        Util.checkNotNull(object);
        Util.checkThat(!this.columns.isEmpty());
        this.elements = Util.checkNotNull(this.getElements(object));
        this.table.setItemCount(this.elements.size());
        this.table.clearAll();
        this.lastSortColumn = null;
    }

    public final List<E> getSelection() {
        int[] nArray = this.table.getSelectionIndices();
        ArrayList<E> arrayList = new ArrayList<E>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.elements.get(n));
        }
        return arrayList;
    }

    public final void scrollToTop() {
        ScrollBar scrollBar = this.table.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(0);
        }
    }

    public final void scrollToBottom() {
        TableItem tableItem = this.table.getItem(this.table.getItemCount() - 1);
        this.table.showItem(tableItem);
    }

    public void setSortingEnabled(boolean bl) {
        this.sortingEnabled = bl;
        if (!bl) {
            this.lastSortColumn = null;
        }
    }

    protected abstract List<E> getElements(Object var1);

    public static abstract class Column<E> {
        private String label;
        private final int orientation;
        private final Event<String> evtLabelChanged = new Event();
        private int lastSortDirection = 1;

        public Column(String string) {
            this(string, 16384);
        }

        public Column(String string, int n) {
            this.label = Util.checkNotNull(string);
            this.orientation = n;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String string) {
            Util.checkNotNull(string);
            if (this.label.equals(string)) {
                return;
            }
            this.label = string;
            this.evtLabelChanged.fire(string);
        }

        protected abstract String getLabel(E var1);

        protected String getToolTipText() {
            return null;
        }

        protected Image getImage(E e) {
            return null;
        }

        protected Color getForeground(E e) {
            return null;
        }

        protected Color getBackground(E e) {
            return null;
        }

        protected int compare(E e, E e2) {
            return 0;
        }
    }
}

