/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tika.config.LoadErrorHandler;

public class ServiceLoader {
    private static volatile ClassLoader contextClassLoader = null;
    private static final Map<Object, RankedService> services = new HashMap<Object, RankedService>();
    private final ClassLoader loader;
    private final LoadErrorHandler handler;
    private final boolean dynamic;
    private static final Pattern COMMENT = Pattern.compile("#.*");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = contextClassLoader;
        if (classLoader == null) {
            classLoader = ServiceLoader.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        contextClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addService(Object object, Object object2, int n) {
        Map<Object, RankedService> map = services;
        synchronized (map) {
            services.put(object, new RankedService(object2, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object removeService(Object object) {
        Map<Object, RankedService> map = services;
        synchronized (map) {
            return services.remove(object);
        }
    }

    public ServiceLoader(ClassLoader classLoader, LoadErrorHandler loadErrorHandler, boolean bl) {
        this.loader = classLoader;
        this.handler = loadErrorHandler;
        this.dynamic = bl;
    }

    public ServiceLoader(ClassLoader classLoader, LoadErrorHandler loadErrorHandler) {
        this(classLoader, loadErrorHandler, false);
    }

    public ServiceLoader(ClassLoader classLoader) {
        this(classLoader, Boolean.getBoolean("org.apache.tika.service.error.warn") ? LoadErrorHandler.WARN : LoadErrorHandler.IGNORE);
    }

    public ServiceLoader() {
        this(ServiceLoader.getContextClassLoader(), Boolean.getBoolean("org.apache.tika.service.error.warn") ? LoadErrorHandler.WARN : LoadErrorHandler.IGNORE, true);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public LoadErrorHandler getLoadErrorHandler() {
        return this.handler;
    }

    public InputStream getResourceAsStream(String string) {
        if (this.loader != null) {
            return this.loader.getResourceAsStream(string);
        }
        return null;
    }

    public <T> Class<? extends T> getServiceClass(Class<T> clazz, String string) throws ClassNotFoundException {
        if (this.loader == null) {
            throw new ClassNotFoundException("Service class " + string + " is not available");
        }
        Class<?> clazz2 = Class.forName(string, true, this.loader);
        if (clazz2.isInterface()) {
            throw new ClassNotFoundException("Service class " + string + " is an interface");
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new ClassNotFoundException("Service class " + string + " does not implement " + clazz.getName());
        }
        return clazz2;
    }

    public Enumeration<URL> findServiceResources(String string) {
        try {
            Enumeration<URL> enumeration = this.loader.getResources(string);
            return enumeration;
        }
        catch (IOException iOException) {
            List list = Collections.emptyList();
            return Collections.enumeration(list);
        }
    }

    public <T> List<T> loadServiceProviders(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.addAll(this.loadDynamicServiceProviders(clazz));
        arrayList.addAll(this.loadStaticServiceProviders(clazz));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> loadDynamicServiceProviders(Class<T> clazz) {
        if (this.dynamic) {
            Map<Object, RankedService> map = services;
            synchronized (map) {
                ArrayList<RankedService> arrayList = new ArrayList<RankedService>(services.values());
                Collections.sort(arrayList);
                ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
                for (RankedService rankedService : arrayList) {
                    if (!rankedService.isInstanceOf(clazz)) continue;
                    arrayList2.add(rankedService.service);
                }
                return arrayList2;
            }
        }
        return new ArrayList(0);
    }

    protected <T> List<String> identifyStaticServiceProviders(Class<T> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.loader != null) {
            String string = clazz.getName();
            Enumeration<URL> enumeration = this.findServiceResources("META-INF/services/" + string);
            for (URL uRL : Collections.list(enumeration)) {
                try {
                    this.collectServiceClassNames(uRL, arrayList);
                }
                catch (IOException iOException) {
                    this.handler.handleLoadError(string, iOException);
                }
            }
        }
        return arrayList;
    }

    public <T> List<T> loadStaticServiceProviders(Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        if (this.loader != null) {
            List<String> list = this.identifyStaticServiceProviders(clazz);
            for (String string : list) {
                try {
                    Class<?> clazz2 = this.loader.loadClass(string);
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    arrayList.add(clazz2.newInstance());
                }
                catch (Throwable throwable) {
                    this.handler.handleLoadError(string, throwable);
                }
            }
        }
        return arrayList;
    }

    private void collectServiceClassNames(URL uRL, Collection<String> collection) throws IOException {
        try (InputStream inputStream = uRL.openStream();){
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String string = bufferedReader.readLine();
            while (string != null) {
                string = COMMENT.matcher(string).replaceFirst("");
                if ((string = WHITESPACE.matcher(string).replaceAll("")).length() > 0) {
                    collection.add(string);
                }
                string = bufferedReader.readLine();
            }
        }
    }

    private static class RankedService
    implements Comparable<RankedService> {
        private Object service;
        private int rank;

        public RankedService(Object object, int n) {
            this.service = object;
            this.rank = n;
        }

        public boolean isInstanceOf(Class<?> clazz) {
            return clazz.isAssignableFrom(this.service.getClass());
        }

        @Override
        public int compareTo(RankedService rankedService) {
            return rankedService.rank - this.rank;
        }
    }
}

