/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.xml.parsers.DocumentBuilder;
import org.apache.tika.concurrent.ConfigurableThreadPoolExecutor;
import org.apache.tika.concurrent.SimpleThreadPoolExecutor;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.DefaultTranslator;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TikaConfig {
    private final ServiceLoader serviceLoader;
    private final CompositeParser parser;
    private final CompositeDetector detector;
    private final Translator translator;
    private final MimeTypes mimeTypes;
    private final ExecutorService executorService;

    private static MimeTypes getDefaultMimeTypes(ClassLoader classLoader) {
        return MimeTypes.getDefaultMimeTypes(classLoader);
    }

    protected static CompositeDetector getDefaultDetector(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
        return new DefaultDetector(mimeTypes, serviceLoader);
    }

    private static CompositeParser getDefaultParser(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
        return new DefaultParser(mimeTypes.getMediaTypeRegistry(), serviceLoader);
    }

    private static Translator getDefaultTranslator(ServiceLoader serviceLoader) {
        return new DefaultTranslator(serviceLoader);
    }

    private static ConfigurableThreadPoolExecutor getDefaultExecutorService() {
        return new SimpleThreadPoolExecutor();
    }

    public TikaConfig(String string) throws TikaException, IOException, SAXException {
        this(Paths.get(string, new String[0]));
    }

    public TikaConfig(Path path) throws TikaException, IOException, SAXException {
        this(path, new ServiceLoader());
    }

    public TikaConfig(Path path, ServiceLoader serviceLoader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(path.toFile()), serviceLoader);
    }

    public TikaConfig(File file) throws TikaException, IOException, SAXException {
        this(file, new ServiceLoader());
    }

    public TikaConfig(File file, ServiceLoader serviceLoader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(file), serviceLoader);
    }

    public TikaConfig(URL uRL) throws TikaException, IOException, SAXException {
        this(uRL, ServiceLoader.getContextClassLoader());
    }

    public TikaConfig(URL uRL, ClassLoader classLoader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(uRL.toString()).getDocumentElement(), classLoader);
    }

    public TikaConfig(URL uRL, ServiceLoader serviceLoader) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(uRL.toString()).getDocumentElement(), serviceLoader);
    }

    public TikaConfig(InputStream inputStream) throws TikaException, IOException, SAXException {
        this(TikaConfig.getBuilder().parse(inputStream));
    }

    public TikaConfig(Document document) throws TikaException, IOException {
        this(document.getDocumentElement());
    }

    public TikaConfig(Document document, ServiceLoader serviceLoader) throws TikaException, IOException {
        this(document.getDocumentElement(), serviceLoader);
    }

    public TikaConfig(Element element) throws TikaException, IOException {
        this(element, TikaConfig.serviceLoaderFromDomElement(element, null));
    }

    public TikaConfig(Element element, ClassLoader classLoader) throws TikaException, IOException {
        this(element, TikaConfig.serviceLoaderFromDomElement(element, classLoader));
    }

    private TikaConfig(Element element, ServiceLoader serviceLoader) throws TikaException, IOException {
        ParserXmlLoader parserXmlLoader = new ParserXmlLoader();
        DetectorXmlLoader detectorXmlLoader = new DetectorXmlLoader();
        TranslatorXmlLoader translatorXmlLoader = new TranslatorXmlLoader();
        ExecutorServiceXmlLoader executorServiceXmlLoader = new ExecutorServiceXmlLoader();
        this.mimeTypes = TikaConfig.typesFromDomElement(element);
        this.detector = (CompositeDetector)detectorXmlLoader.loadOverall(element, this.mimeTypes, serviceLoader);
        this.parser = (CompositeParser)parserXmlLoader.loadOverall(element, this.mimeTypes, serviceLoader);
        this.translator = (Translator)translatorXmlLoader.loadOverall(element, this.mimeTypes, serviceLoader);
        this.executorService = (ExecutorService)executorServiceXmlLoader.loadOverall(element, this.mimeTypes, serviceLoader);
        this.serviceLoader = serviceLoader;
    }

    public TikaConfig(ClassLoader classLoader) throws MimeTypeException, IOException {
        this.serviceLoader = new ServiceLoader(classLoader);
        this.mimeTypes = TikaConfig.getDefaultMimeTypes(classLoader);
        this.detector = TikaConfig.getDefaultDetector(this.mimeTypes, this.serviceLoader);
        this.parser = TikaConfig.getDefaultParser(this.mimeTypes, this.serviceLoader);
        this.translator = TikaConfig.getDefaultTranslator(this.serviceLoader);
        this.executorService = TikaConfig.getDefaultExecutorService();
    }

    public TikaConfig() throws TikaException, IOException {
        this.serviceLoader = new ServiceLoader();
        String string = System.getProperty("tika.config");
        if (string == null) {
            string = System.getenv("TIKA_CONFIG");
        }
        if (string == null) {
            this.mimeTypes = TikaConfig.getDefaultMimeTypes(ServiceLoader.getContextClassLoader());
            this.parser = TikaConfig.getDefaultParser(this.mimeTypes, this.serviceLoader);
            this.detector = TikaConfig.getDefaultDetector(this.mimeTypes, this.serviceLoader);
            this.translator = TikaConfig.getDefaultTranslator(this.serviceLoader);
            this.executorService = TikaConfig.getDefaultExecutorService();
        } else {
            try (InputStream inputStream = TikaConfig.getConfigInputStream(string, this.serviceLoader);){
                Element element = TikaConfig.getBuilder().parse(inputStream).getDocumentElement();
                ParserXmlLoader parserXmlLoader = new ParserXmlLoader();
                DetectorXmlLoader detectorXmlLoader = new DetectorXmlLoader();
                TranslatorXmlLoader translatorXmlLoader = new TranslatorXmlLoader();
                ExecutorServiceXmlLoader executorServiceXmlLoader = new ExecutorServiceXmlLoader();
                this.mimeTypes = TikaConfig.typesFromDomElement(element);
                this.parser = (CompositeParser)parserXmlLoader.loadOverall(element, this.mimeTypes, this.serviceLoader);
                this.detector = (CompositeDetector)detectorXmlLoader.loadOverall(element, this.mimeTypes, this.serviceLoader);
                this.translator = (Translator)translatorXmlLoader.loadOverall(element, this.mimeTypes, this.serviceLoader);
                this.executorService = (ExecutorService)executorServiceXmlLoader.loadOverall(element, this.mimeTypes, this.serviceLoader);
            }
            catch (SAXException sAXException) {
                throw new TikaException("Specified Tika configuration has syntax errors: " + string, sAXException);
            }
        }
    }

    private static InputStream getConfigInputStream(String string, ServiceLoader serviceLoader) throws TikaException, IOException {
        Path path;
        InputStream inputStream = null;
        try {
            inputStream = new URL(string).openStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = serviceLoader.getResourceAsStream(string);
        }
        if (inputStream == null && Files.isRegularFile(path = Paths.get(string, new String[0]), new LinkOption[0])) {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
        }
        if (inputStream == null) {
            throw new TikaException("Specified Tika configuration not found: " + string);
        }
        return inputStream;
    }

    private static String getText(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.getNodeType() == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                stringBuilder.append(TikaConfig.getText(nodeList.item(i)));
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public Parser getParser(MediaType mediaType) {
        return this.parser.getParsers().get(mediaType);
    }

    public Parser getParser() {
        return this.parser;
    }

    public Detector getDetector() {
        return this.detector;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public MimeTypes getMimeRepository() {
        return this.mimeTypes;
    }

    public MediaTypeRegistry getMediaTypeRegistry() {
        return this.mimeTypes.getMediaTypeRegistry();
    }

    public ServiceLoader getServiceLoader() {
        return this.serviceLoader;
    }

    public static TikaConfig getDefaultConfig() {
        try {
            return new TikaConfig();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read default configuration", iOException);
        }
        catch (TikaException tikaException) {
            throw new RuntimeException("Unable to access default configuration", tikaException);
        }
    }

    private static DocumentBuilder getBuilder() throws TikaException {
        return new ParseContext().getDocumentBuilder();
    }

    private static Element getChild(Element element, String string) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    private static List<Element> getTopLevelElementChildren(Element element, String string, String string2) throws TikaException {
        NodeList nodeList;
        Node node = null;
        if (string != null) {
            nodeList = element.getElementsByTagName(string);
            if (nodeList.getLength() > 1) {
                throw new TikaException("Properties may not contain multiple " + string + " entries");
            }
            if (nodeList.getLength() == 1) {
                node = nodeList.item(0);
            }
        } else {
            node = element;
        }
        if (node != null) {
            nodeList = node.getChildNodes();
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                Node node2 = nodeList.item(i);
                if (!(node2 instanceof Element) || !string2.equals((element2 = (Element)node2).getTagName())) continue;
                arrayList.add(element2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private static MimeTypes typesFromDomElement(Element element) throws TikaException, IOException {
        Element element2 = TikaConfig.getChild(element, "mimeTypeRepository");
        if (element2 != null && element2.hasAttribute("resource")) {
            return MimeTypesFactory.create(element2.getAttribute("resource"));
        }
        return TikaConfig.getDefaultMimeTypes(null);
    }

    private static Set<MediaType> mediaTypesListFromDomElement(Element element, String string) throws TikaException, IOException {
        HashSet<MediaType> hashSet = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals((element2 = (Element)node).getTagName())) continue;
            String string2 = TikaConfig.getText(element2);
            MediaType mediaType = MediaType.parse(string2);
            if (mediaType != null) {
                if (hashSet == null) {
                    hashSet = new HashSet<MediaType>();
                }
                hashSet.add(mediaType);
                continue;
            }
            throw new TikaException("Invalid media type name: " + string2);
        }
        if (hashSet != null) {
            return hashSet;
        }
        return Collections.emptySet();
    }

    private static ServiceLoader serviceLoaderFromDomElement(Element element, ClassLoader classLoader) {
        ServiceLoader serviceLoader;
        Element element2 = TikaConfig.getChild(element, "service-loader");
        if (element2 != null) {
            boolean bl = Boolean.parseBoolean(element2.getAttribute("dynamic"));
            LoadErrorHandler loadErrorHandler = LoadErrorHandler.IGNORE;
            String string = element2.getAttribute("loadErrorHandler");
            if (LoadErrorHandler.WARN.toString().equalsIgnoreCase(string)) {
                loadErrorHandler = LoadErrorHandler.WARN;
            } else if (LoadErrorHandler.THROW.toString().equalsIgnoreCase(string)) {
                loadErrorHandler = LoadErrorHandler.THROW;
            }
            serviceLoader = new ServiceLoader(classLoader, loadErrorHandler, bl);
        } else {
            serviceLoader = classLoader != null ? new ServiceLoader(classLoader) : new ServiceLoader();
        }
        return serviceLoader;
    }

    private static class ParserXmlLoader
    extends XmlLoader<CompositeParser, Parser> {
        private ParserXmlLoader() {
        }

        @Override
        boolean supportsComposite() {
            return true;
        }

        @Override
        String getParentTagName() {
            return "parsers";
        }

        @Override
        String getLoaderTagName() {
            return "parser";
        }

        @Override
        Class<? extends Parser> getLoaderClass() {
            return Parser.class;
        }

        @Override
        Parser preLoadOne(Class<? extends Parser> clazz, String string, MimeTypes mimeTypes) throws TikaException {
            if (AutoDetectParser.class.isAssignableFrom(clazz)) {
                throw new TikaException("AutoDetectParser not supported in a <parser> configuration element: " + string);
            }
            return null;
        }

        @Override
        boolean isComposite(Parser parser) {
            return parser instanceof CompositeParser;
        }

        @Override
        boolean isComposite(Class<? extends Parser> clazz) {
            return CompositeParser.class.isAssignableFrom(clazz) || ParserDecorator.class.isAssignableFrom(clazz);
        }

        @Override
        CompositeParser createDefault(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            return TikaConfig.getDefaultParser(mimeTypes, serviceLoader);
        }

        @Override
        CompositeParser createComposite(List<Parser> list, MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            MediaTypeRegistry mediaTypeRegistry = mimeTypes.getMediaTypeRegistry();
            return new CompositeParser(mediaTypeRegistry, list);
        }

        @Override
        Parser createComposite(Class<? extends Parser> clazz, List<Parser> list, Set<Class<? extends Parser>> set, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            Parser parser = null;
            Constructor<? extends Parser> constructor = null;
            MediaTypeRegistry mediaTypeRegistry = mimeTypes.getMediaTypeRegistry();
            if (parser == null) {
                try {
                    constructor = clazz.getConstructor(MediaTypeRegistry.class, ServiceLoader.class, Collection.class);
                    parser = constructor.newInstance(mediaTypeRegistry, serviceLoader, set);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (parser == null) {
                try {
                    constructor = clazz.getConstructor(MediaTypeRegistry.class, List.class, Collection.class);
                    parser = constructor.newInstance(mediaTypeRegistry, list, set);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (parser == null) {
                try {
                    constructor = clazz.getConstructor(MediaTypeRegistry.class, List.class);
                    parser = constructor.newInstance(mediaTypeRegistry, list);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (parser == null && ParserDecorator.class.isAssignableFrom(clazz)) {
                try {
                    CompositeParser compositeParser = null;
                    compositeParser = list.size() == 1 && set.size() == 0 && list.get(0) instanceof CompositeParser ? (CompositeParser)list.get(0) : new CompositeParser(mediaTypeRegistry, list, set);
                    constructor = clazz.getConstructor(Parser.class);
                    parser = constructor.newInstance(compositeParser);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return parser;
        }

        @Override
        Parser decorate(Parser parser, Element element) throws IOException, TikaException {
            Set<MediaType> set;
            Parser parser2 = parser;
            Set<MediaType> set2 = TikaConfig.mediaTypesListFromDomElement(element, "mime");
            if (!set2.isEmpty()) {
                parser2 = ParserDecorator.withTypes(parser2, set2);
            }
            if (!(set = TikaConfig.mediaTypesListFromDomElement(element, "mime-exclude")).isEmpty()) {
                parser2 = ParserDecorator.withoutTypes(parser2, set);
            }
            return parser2;
        }
    }

    private static class DetectorXmlLoader
    extends XmlLoader<CompositeDetector, Detector> {
        private DetectorXmlLoader() {
        }

        @Override
        boolean supportsComposite() {
            return true;
        }

        @Override
        String getParentTagName() {
            return "detectors";
        }

        @Override
        String getLoaderTagName() {
            return "detector";
        }

        @Override
        Class<? extends Detector> getLoaderClass() {
            return Detector.class;
        }

        @Override
        Detector preLoadOne(Class<? extends Detector> clazz, String string, MimeTypes mimeTypes) throws TikaException {
            if (MimeTypes.class.equals(clazz)) {
                return mimeTypes;
            }
            return null;
        }

        @Override
        boolean isComposite(Detector detector) {
            return detector instanceof CompositeDetector;
        }

        @Override
        boolean isComposite(Class<? extends Detector> clazz) {
            return CompositeDetector.class.isAssignableFrom(clazz);
        }

        @Override
        CompositeDetector createDefault(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            return TikaConfig.getDefaultDetector(mimeTypes, serviceLoader);
        }

        @Override
        CompositeDetector createComposite(List<Detector> list, MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            MediaTypeRegistry mediaTypeRegistry = mimeTypes.getMediaTypeRegistry();
            return new CompositeDetector(mediaTypeRegistry, list);
        }

        @Override
        Detector createComposite(Class<? extends Detector> clazz, List<Detector> list, Set<Class<? extends Detector>> set, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            Constructor<? extends Detector> constructor;
            Detector detector = null;
            MediaTypeRegistry mediaTypeRegistry = mimeTypes.getMediaTypeRegistry();
            if (detector == null) {
                try {
                    constructor = clazz.getConstructor(MimeTypes.class, ServiceLoader.class, Collection.class);
                    detector = constructor.newInstance(mimeTypes, serviceLoader, set);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (detector == null) {
                try {
                    constructor = clazz.getConstructor(MediaTypeRegistry.class, List.class, Collection.class);
                    detector = constructor.newInstance(mediaTypeRegistry, list, set);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (detector == null) {
                try {
                    constructor = clazz.getConstructor(MediaTypeRegistry.class, List.class);
                    detector = constructor.newInstance(mediaTypeRegistry, list);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (detector == null) {
                try {
                    constructor = clazz.getConstructor(List.class);
                    detector = constructor.newInstance(list);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return detector;
        }

        @Override
        Detector decorate(Detector detector, Element element) {
            return detector;
        }
    }

    private static class TranslatorXmlLoader
    extends XmlLoader<Translator, Translator> {
        private TranslatorXmlLoader() {
        }

        @Override
        boolean supportsComposite() {
            return false;
        }

        @Override
        String getParentTagName() {
            return null;
        }

        @Override
        String getLoaderTagName() {
            return "translator";
        }

        @Override
        Class<? extends Translator> getLoaderClass() {
            return Translator.class;
        }

        @Override
        Translator preLoadOne(Class<? extends Translator> clazz, String string, MimeTypes mimeTypes) throws TikaException {
            return null;
        }

        @Override
        boolean isComposite(Translator translator) {
            return false;
        }

        @Override
        boolean isComposite(Class<? extends Translator> clazz) {
            return false;
        }

        @Override
        Translator createDefault(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            return TikaConfig.getDefaultTranslator(serviceLoader);
        }

        @Override
        Translator createComposite(List<Translator> list, MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            return list.get(0);
        }

        @Override
        Translator createComposite(Class<? extends Translator> clazz, List<Translator> list, Set<Class<? extends Translator>> set, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            throw new InstantiationException("Only one translator supported");
        }

        @Override
        Translator decorate(Translator translator, Element element) {
            return translator;
        }
    }

    private static class ExecutorServiceXmlLoader
    extends XmlLoader<ConfigurableThreadPoolExecutor, ConfigurableThreadPoolExecutor> {
        private ExecutorServiceXmlLoader() {
        }

        @Override
        ConfigurableThreadPoolExecutor createComposite(Class<? extends ConfigurableThreadPoolExecutor> clazz, List<ConfigurableThreadPoolExecutor> list, Set<Class<? extends ConfigurableThreadPoolExecutor>> set, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            throw new InstantiationException("Only one executor service supported");
        }

        @Override
        ConfigurableThreadPoolExecutor createComposite(List<ConfigurableThreadPoolExecutor> list, MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            return list.get(0);
        }

        @Override
        ConfigurableThreadPoolExecutor createDefault(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
            return TikaConfig.getDefaultExecutorService();
        }

        @Override
        ConfigurableThreadPoolExecutor decorate(ConfigurableThreadPoolExecutor configurableThreadPoolExecutor, Element element) throws IOException, TikaException {
            Element element2;
            Element element3 = TikaConfig.getChild(element, "max-threads");
            if (element3 != null) {
                configurableThreadPoolExecutor.setMaximumPoolSize(Integer.parseInt(TikaConfig.getText(element3)));
            }
            if ((element2 = TikaConfig.getChild(element, "core-threads")) != null) {
                configurableThreadPoolExecutor.setCorePoolSize(Integer.parseInt(TikaConfig.getText(element2)));
            }
            return configurableThreadPoolExecutor;
        }

        @Override
        Class<? extends ConfigurableThreadPoolExecutor> getLoaderClass() {
            return ConfigurableThreadPoolExecutor.class;
        }

        @Override
        ConfigurableThreadPoolExecutor loadOne(Element element, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws TikaException, IOException {
            return (ConfigurableThreadPoolExecutor)super.loadOne(element, mimeTypes, serviceLoader);
        }

        @Override
        boolean supportsComposite() {
            return false;
        }

        @Override
        String getParentTagName() {
            return null;
        }

        @Override
        String getLoaderTagName() {
            return "executor-service";
        }

        @Override
        boolean isComposite(ConfigurableThreadPoolExecutor configurableThreadPoolExecutor) {
            return false;
        }

        @Override
        boolean isComposite(Class<? extends ConfigurableThreadPoolExecutor> clazz) {
            return false;
        }

        @Override
        ConfigurableThreadPoolExecutor preLoadOne(Class<? extends ConfigurableThreadPoolExecutor> clazz, String string, MimeTypes mimeTypes) throws TikaException {
            return null;
        }
    }

    private static abstract class XmlLoader<CT, T> {
        private XmlLoader() {
        }

        abstract boolean supportsComposite();

        abstract String getParentTagName();

        abstract String getLoaderTagName();

        abstract Class<? extends T> getLoaderClass();

        abstract boolean isComposite(T var1);

        abstract boolean isComposite(Class<? extends T> var1);

        abstract T preLoadOne(Class<? extends T> var1, String var2, MimeTypes var3) throws TikaException;

        abstract CT createDefault(MimeTypes var1, ServiceLoader var2);

        abstract CT createComposite(List<T> var1, MimeTypes var2, ServiceLoader var3);

        abstract T createComposite(Class<? extends T> var1, List<T> var2, Set<Class<? extends T>> var3, MimeTypes var4, ServiceLoader var5) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        abstract T decorate(T var1, Element var2) throws IOException, TikaException;

        CT loadOverall(Element element, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws TikaException, IOException {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (Element element2 : TikaConfig.getTopLevelElementChildren(element, this.getParentTagName(), this.getLoaderTagName())) {
                T t = this.loadOne(element2, mimeTypes, serviceLoader);
                if (t == null) continue;
                arrayList.add(t);
            }
            if (arrayList.isEmpty()) {
                return this.createDefault(mimeTypes, serviceLoader);
            }
            if (arrayList.size() == 1) {
                Iterator<Element> iterator = arrayList.get(0);
                if (this.isComposite(iterator)) {
                    return (CT)iterator;
                }
            } else if (!this.supportsComposite()) {
                return (CT)arrayList.get(0);
            }
            return this.createComposite(arrayList, mimeTypes, serviceLoader);
        }

        T loadOne(Element element, MimeTypes mimeTypes, ServiceLoader serviceLoader) throws TikaException, IOException {
            String string = element.getAttribute("class");
            T t = null;
            try {
                Class<T> clazz = serviceLoader.getServiceClass(this.getLoaderClass(), string);
                t = this.preLoadOne(clazz, string, mimeTypes);
                if (t != null) {
                    return t;
                }
                if (this.isComposite(clazz)) {
                    NodeList nodeList;
                    ArrayList<NodeList> arrayList = new ArrayList<NodeList>();
                    NodeList nodeList2 = element.getElementsByTagName(this.getLoaderTagName());
                    if (nodeList2.getLength() > 0) {
                        for (int i = 0; i < nodeList2.getLength(); ++i) {
                            nodeList = this.loadOne((Element)nodeList2.item(i), mimeTypes, serviceLoader);
                            if (nodeList == null) continue;
                            arrayList.add(nodeList);
                        }
                    }
                    HashSet<Class<T>> hashSet = new HashSet<Class<T>>();
                    nodeList = element.getElementsByTagName(this.getLoaderTagName() + "-exclude");
                    if (nodeList.getLength() > 0) {
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Element element2 = (Element)nodeList.item(i);
                            String string2 = element2.getAttribute("class");
                            hashSet.add(serviceLoader.getServiceClass(this.getLoaderClass(), string2));
                        }
                    }
                    if ((t = (T)this.createComposite(clazz, arrayList, hashSet, mimeTypes, serviceLoader)) == null) {
                        t = clazz.newInstance();
                    }
                } else {
                    t = clazz.newInstance();
                }
                t = this.decorate(t, element);
                return t;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (serviceLoader.getLoadErrorHandler() == LoadErrorHandler.THROW) {
                    throw new TikaException("Unable to find a " + this.getLoaderTagName() + " class: " + string, classNotFoundException);
                }
                serviceLoader.getLoadErrorHandler().handleLoadError(string, classNotFoundException);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TikaException("Unable to access a " + this.getLoaderTagName() + " class: " + string, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TikaException("Unable to create a " + this.getLoaderTagName() + " class: " + string, invocationTargetException);
            }
            catch (InstantiationException instantiationException) {
                throw new TikaException("Unable to instantiate a " + this.getLoaderTagName() + " class: " + string, instantiationException);
            }
        }
    }
}

