/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.util.Collection;
import java.util.List;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.utils.ServiceLoaderUtils;

public class DefaultDetector
extends CompositeDetector {
    private static final long serialVersionUID = -8170114575326908027L;
    private final transient ServiceLoader loader;

    private static List<Detector> getDefaultDetectors(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
        List<Detector> list = serviceLoader.loadStaticServiceProviders(Detector.class);
        ServiceLoaderUtils.sortLoadedClasses(list);
        list.add(mimeTypes);
        return list;
    }

    public DefaultDetector(MimeTypes mimeTypes, ServiceLoader serviceLoader, Collection<Class<? extends Detector>> collection) {
        super(mimeTypes.getMediaTypeRegistry(), DefaultDetector.getDefaultDetectors(mimeTypes, serviceLoader), collection);
        this.loader = serviceLoader;
    }

    public DefaultDetector(MimeTypes mimeTypes, ServiceLoader serviceLoader) {
        this(mimeTypes, serviceLoader, null);
    }

    public DefaultDetector(MimeTypes mimeTypes, ClassLoader classLoader) {
        this(mimeTypes, new ServiceLoader(classLoader));
    }

    public DefaultDetector(ClassLoader classLoader) {
        this(MimeTypes.getDefaultMimeTypes(), classLoader);
    }

    public DefaultDetector(MimeTypes mimeTypes) {
        this(mimeTypes, new ServiceLoader());
    }

    public DefaultDetector() {
        this(MimeTypes.getDefaultMimeTypes());
    }

    @Override
    public List<Detector> getDetectors() {
        if (this.loader != null) {
            List<Detector> list = this.loader.loadDynamicServiceProviders(Detector.class);
            list.addAll(super.getDetectors());
            return list;
        }
        return super.getDetectors();
    }
}

