/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.detect.NNTrainedModelBuilder;
import org.apache.tika.detect.TrainedModelDetector;
import org.apache.tika.mime.MediaType;

public class NNExampleModelDetector
extends TrainedModelDetector {
    private static final String EXAMPLE_NNMODEL_FILE = "tika-example.nnmodel";
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(NNExampleModelDetector.class.getName());

    public NNExampleModelDetector() {
    }

    public NNExampleModelDetector(Path path) {
        this.loadDefaultModels(path);
    }

    public NNExampleModelDetector(File file) {
        this.loadDefaultModels(file);
    }

    @Override
    public void loadDefaultModels(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        NNTrainedModelBuilder nNTrainedModelBuilder = new NNTrainedModelBuilder();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#")) {
                    this.readDescription(nNTrainedModelBuilder, string);
                    continue;
                }
                this.readNNParams(nNTrainedModelBuilder, string);
                super.registerModels(nNTrainedModelBuilder.getType(), nNTrainedModelBuilder.build());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read the default media type registry", iOException);
        }
    }

    @Override
    public void loadDefaultModels(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = TrainedModelDetector.class.getClassLoader();
        }
        String string = TrainedModelDetector.class.getPackage().getName().replace('.', '/') + "/";
        URL uRL = classLoader.getResource(string + EXAMPLE_NNMODEL_FILE);
        Objects.requireNonNull(uRL, "required resource " + string + "tika-example.nnmodel not found");
        try (InputStream inputStream = uRL.openStream();){
            this.loadDefaultModels(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read the default media type registry", iOException);
        }
    }

    private void readDescription(NNTrainedModelBuilder nNTrainedModelBuilder, String string) {
        String[] stringArray = string.split("\t");
        try {
            MediaType mediaType = MediaType.parse(stringArray[1]);
            int n = Integer.parseInt(stringArray[2]);
            int n2 = Integer.parseInt(stringArray[3]);
            int n3 = Integer.parseInt(stringArray[4]);
            nNTrainedModelBuilder.setNumOfInputs(n);
            nNTrainedModelBuilder.setNumOfHidden(n2);
            nNTrainedModelBuilder.setNumOfOutputs(n3);
            nNTrainedModelBuilder.setType(mediaType);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Unable to parse the model configuration", exception);
            }
            throw new RuntimeException("Unable to parse the model configuration", exception);
        }
    }

    private void readNNParams(NNTrainedModelBuilder nNTrainedModelBuilder, String string) {
        String[] stringArray = string.split("\t");
        int n = stringArray.length;
        float[] fArray = new float[n];
        try {
            int n2 = 0;
            for (String string2 : stringArray) {
                fArray[n2] = Float.parseFloat(string2);
                ++n2;
            }
            nNTrainedModelBuilder.setParams(fArray);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Unable to parse the model configuration", exception);
            }
            throw new RuntimeException("Unable to parse the model configuration", exception);
        }
    }
}

