/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

public class NameDetector
implements Detector {
    private final Map<Pattern, MediaType> patterns;

    public NameDetector(Map<Pattern, MediaType> map) {
        this.patterns = map;
    }

    @Override
    public MediaType detect(InputStream inputStream, Metadata metadata) {
        String string = metadata.get("resourceName");
        if (string != null) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = string.indexOf(63);
            if (n5 != -1) {
                string = string.substring(0, n5);
            }
            if ((n4 = string.indexOf(35)) != -1) {
                string = string.substring(0, n4);
            }
            if ((n3 = string.lastIndexOf(47)) != -1) {
                string = string.substring(n3 + 1);
            }
            if ((n2 = string.lastIndexOf(92)) != -1) {
                string = string.substring(n2 + 1);
            }
            if ((n = string.indexOf(37)) != -1) {
                try {
                    string = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException("UTF-8 not supported", unsupportedEncodingException);
                }
            }
            if ((string = string.trim()).length() > 0) {
                for (Pattern pattern : this.patterns.keySet()) {
                    if (!pattern.matcher(string).matches()) continue;
                    return this.patterns.get(pattern);
                }
            }
        }
        return MediaType.OCTET_STREAM;
    }
}

