/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

public class TextStatistics {
    private final int[] counts = new int[256];
    private int total = 0;

    public void addData(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = byArray[n + i] & 0xFF;
            this.counts[n3] = this.counts[n3] + 1;
            ++this.total;
        }
    }

    public boolean isMostlyAscii() {
        int n = this.count(0, 32);
        int n2 = this.count(32, 128);
        int n3 = this.countSafeControl();
        return this.total > 0 && (n - n3) * 100 < this.total * 2 && (n2 + n3) * 100 > this.total * 90;
    }

    public boolean looksLikeUTF8() {
        int n;
        int n2 = this.count(0, 32);
        int n3 = this.count(32, 128);
        int n4 = this.countSafeControl();
        int n5 = 0;
        int[] nArray = new int[]{this.count(192, 224), this.count(224, 240), this.count(240, 248)};
        for (n = 0; n < nArray.length; ++n) {
            n3 += nArray[n];
            n5 += (n + 1) * nArray[n];
        }
        n = this.count(128, 192);
        return n3 > 0 && n <= n5 && n >= n5 - 3 && this.count(3968, 256) == 0 && (n2 - n4) * 100 < n3 * 2;
    }

    public int count() {
        return this.total;
    }

    public int count(int n) {
        return this.counts[n & 0xFF];
    }

    public int countControl() {
        return this.count(0, 32) - this.countSafeControl();
    }

    public int countSafeAscii() {
        return this.count(32, 128) + this.countSafeControl();
    }

    public int countEightBit() {
        return this.count(128, 256);
    }

    private int count(int n, int n2) {
        assert (0 <= n && n2 <= this.counts.length);
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 += this.counts[i];
        }
        return n3;
    }

    private int countSafeControl() {
        return this.count(9) + this.count(10) + this.count(13) + this.count(12) + this.count(27);
    }
}

