/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.sax.OfflineContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRootExtractor {
    public QName extractRootElement(byte[] byArray) {
        return this.extractRootElement(new ByteArrayInputStream(byArray));
    }

    public QName extractRootElement(InputStream inputStream) {
        ExtractorHandler extractorHandler = new ExtractorHandler();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            try {
                sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            sAXParserFactory.newSAXParser().parse((InputStream)new CloseShieldInputStream(inputStream), (DefaultHandler)new OfflineContentHandler(extractorHandler));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return extractorHandler.rootElement;
    }

    private static class ExtractorHandler
    extends DefaultHandler {
        private QName rootElement = null;

        private ExtractorHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.rootElement = new QName(string, string2);
            throw new SAXException("Aborting: root element received");
        }
    }
}

