/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ParsingEmbeddedDocumentExtractor
implements EmbeddedDocumentExtractor {
    private static final File ABSTRACT_PATH = new File("");
    private static final Parser DELEGATING_PARSER = new DelegatingParser();
    private final ParseContext context;

    public ParsingEmbeddedDocumentExtractor(ParseContext parseContext) {
        this.context = parseContext;
    }

    @Override
    public boolean shouldParseEmbedded(Metadata metadata) {
        String string;
        DocumentSelector documentSelector = this.context.get(DocumentSelector.class);
        if (documentSelector != null) {
            return documentSelector.select(metadata);
        }
        FilenameFilter filenameFilter = this.context.get(FilenameFilter.class);
        if (filenameFilter != null && (string = metadata.get("resourceName")) != null) {
            return filenameFilter.accept(ABSTRACT_PATH, string);
        }
        return true;
    }

    @Override
    public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean bl) throws SAXException, IOException {
        Object object;
        Object object2;
        if (bl) {
            object2 = new AttributesImpl();
            ((AttributesImpl)object2).addAttribute("", "class", "class", "CDATA", "package-entry");
            contentHandler.startElement("http://www.w3.org/1999/xhtml", "div", "div", (Attributes)object2);
        }
        if ((object2 = metadata.get("resourceName")) != null && ((String)object2).length() > 0 && bl) {
            contentHandler.startElement("http://www.w3.org/1999/xhtml", "h1", "h1", new AttributesImpl());
            object = ((String)object2).toCharArray();
            contentHandler.characters((char[])object, 0, ((Object)object).length);
            contentHandler.endElement("http://www.w3.org/1999/xhtml", "h1", "h1");
        }
        try {
            object = new TemporaryResources();
            try {
                Object object3;
                TikaInputStream tikaInputStream = TikaInputStream.get(new CloseShieldInputStream(inputStream), (TemporaryResources)object);
                if (inputStream instanceof TikaInputStream && (object3 = ((TikaInputStream)inputStream).getOpenContainer()) != null) {
                    tikaInputStream.setOpenContainer(object3);
                }
                DELEGATING_PARSER.parse(tikaInputStream, new EmbeddedContentHandler(new BodyContentHandler(contentHandler)), metadata, this.context);
            }
            finally {
                ((TemporaryResources)object).close();
            }
        }
        catch (EncryptedDocumentException encryptedDocumentException) {
        }
        catch (TikaException tikaException) {
            // empty catch block
        }
        if (bl) {
            contentHandler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
        }
    }
}

