/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;

public class EndianUtils {
    private static final int LONG_SIZE = 8;

    public static short readShortLE(InputStream inputStream) throws IOException, BufferUnderrunException {
        return (short)EndianUtils.readUShortLE(inputStream);
    }

    public static short readShortBE(InputStream inputStream) throws IOException, BufferUnderrunException {
        return (short)EndianUtils.readUShortBE(inputStream);
    }

    public static int readUShortLE(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return (n << 8) + (n2 << 0);
    }

    public static int readUShortBE(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return (n2 << 8) + (n << 0);
    }

    public static int readIntLE(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public static int readIntBE(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public static long readLongLE(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = inputStream.read();
        if ((n8 | (n7 = inputStream.read()) | (n6 = inputStream.read()) | (n5 = inputStream.read()) | (n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return ((long)n << 56) + ((long)n2 << 48) + ((long)n3 << 40) + ((long)n4 << 32) + ((long)n5 << 24) + (long)(n6 << 16) + (long)(n7 << 8) + (long)(n8 << 0);
    }

    public static long readLongBE(InputStream inputStream) throws IOException, BufferUnderrunException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = inputStream.read();
        if ((n8 | (n7 = inputStream.read()) | (n6 = inputStream.read()) | (n5 = inputStream.read()) | (n4 = inputStream.read()) | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new BufferUnderrunException();
        }
        return ((long)n8 << 56) + ((long)n7 << 48) + ((long)n6 << 40) + ((long)n5 << 32) + ((long)n4 << 24) + (long)(n3 << 16) + (long)(n2 << 8) + (long)(n << 0);
    }

    public static long readUE7(InputStream inputStream) throws IOException {
        int n;
        long l = 0L;
        while ((n = inputStream.read()) >= 0) {
            l <<= 7;
            if ((n & 0x80) == 128) {
                l += (long)(n & 0x7F);
                continue;
            }
            l += (long)n;
            break;
        }
        return l;
    }

    public static short getShortLE(byte[] byArray) {
        return EndianUtils.getShortLE(byArray, 0);
    }

    public static short getShortLE(byte[] byArray, int n) {
        return (short)EndianUtils.getUShortLE(byArray, n);
    }

    public static int getUShortLE(byte[] byArray) {
        return EndianUtils.getUShortLE(byArray, 0);
    }

    public static int getUShortLE(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n3 << 8) + (n2 << 0);
    }

    public static short getShortBE(byte[] byArray) {
        return EndianUtils.getShortBE(byArray, 0);
    }

    public static short getShortBE(byte[] byArray, int n) {
        return (short)EndianUtils.getUShortBE(byArray, n);
    }

    public static int getUShortBE(byte[] byArray) {
        return EndianUtils.getUShortBE(byArray, 0);
    }

    public static int getUShortBE(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] & 0xFF;
        return (n2 << 8) + (n3 << 0);
    }

    public static int getIntLE(byte[] byArray) {
        return EndianUtils.getIntLE(byArray, 0);
    }

    public static int getIntLE(byte[] byArray, int n) {
        int n2 = n;
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2++] & 0xFF;
        return (n6 << 24) + (n5 << 16) + (n4 << 8) + (n3 << 0);
    }

    public static int getIntBE(byte[] byArray) {
        return EndianUtils.getIntBE(byArray, 0);
    }

    public static int getIntBE(byte[] byArray, int n) {
        int n2 = n;
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2++] & 0xFF;
        return (n3 << 24) + (n4 << 16) + (n5 << 8) + (n6 << 0);
    }

    public static long getUIntLE(byte[] byArray) {
        return EndianUtils.getUIntLE(byArray, 0);
    }

    public static long getUIntLE(byte[] byArray, int n) {
        long l = EndianUtils.getIntLE(byArray, n);
        return l & 0xFFFFFFFFL;
    }

    public static long getUIntBE(byte[] byArray) {
        return EndianUtils.getUIntBE(byArray, 0);
    }

    public static long getUIntBE(byte[] byArray, int n) {
        long l = EndianUtils.getIntBE(byArray, n);
        return l & 0xFFFFFFFFL;
    }

    public static long getLongLE(byte[] byArray, int n) {
        long l = 0L;
        for (int i = n + 8 - 1; i >= n; --i) {
            l <<= 8;
            l |= (long)(0xFF & byArray[i]);
        }
        return l;
    }

    public static int ubyteToInt(byte by) {
        return by & 0xFF;
    }

    public static short getUByte(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF);
    }

    public static class BufferUnderrunException
    extends TikaException {
        private static final long serialVersionUID = 8358288231138076276L;

        public BufferUnderrunException() {
            super("Insufficient data left in stream for required read");
        }
    }
}

